/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.PropertySingleton;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.resources.Errors;

abstract class Field<V>
extends Property {
    Field() {
    }

    static boolean isSingleton(int maximumOccurs) {
        return maximumOccurs <= 1;
    }

    public abstract V getValue() throws IllegalStateException;

    public Collection<V> getValues() {
        return new PropertySingleton(this);
    }

    public abstract void setValue(V var1);

    public void setValues(Collection<? extends V> values) throws IllegalArgumentException {
        V value = null;
        Iterator<V> it = values.iterator();
        if (it.hasNext()) {
            value = it.next();
            if (it.hasNext()) {
                throw new IllegalArgumentException(Errors.format((short)161, (Object)1, (Object)this.getName()));
            }
        }
        this.setValue(value);
    }

    static boolean isDeprecated(AbstractIdentifiedType type) {
        return type instanceof Deprecable && type.isDeprecated();
    }
}

