/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;

@Mojo(name="check-bundle-list-for-snapshots", requiresDependencyResolution=ResolutionScope.TEST)
public class CheckBundleListForSnapshotsMojo
extends AbstractUsingBundleListMojo {
    @Parameter(defaultValue="true")
    private boolean failOnSnapshot;

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        ArrayList<Bundle> snapshots = new ArrayList<Bundle>();
        BundleList bundleList = this.getInitializedBundleList();
        for (StartLevel level : bundleList.getStartLevels()) {
            for (Bundle bundle : level.getBundles()) {
                if (!this.isSnapshot(bundle)) continue;
                snapshots.add(bundle);
            }
        }
        if (!snapshots.isEmpty()) {
            this.getLog().error((CharSequence)"The following entries in the bundle list file are SNAPSHOTs:");
            for (Bundle bundle : snapshots) {
                this.getLog().error((CharSequence)String.format("     %s:%s:%s", bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion()));
            }
            if (this.failOnSnapshot) {
                throw new MojoFailureException("SNAPSHOTs were found in the bundle list. See log.");
            }
        }
    }

    private boolean isSnapshot(Bundle bundle) {
        return bundle.getVersion().endsWith("SNAPSHOT");
    }
}

