/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.http.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.clam.internal.ClamUtil;
import org.jetbrains.annotations.NotNull;

public class RequestUtil {
    private RequestUtil() {
    }

    static String path(@NotNull SlingHttpServletRequest request) throws Exception {
        String value = request.getParameter("path");
        if (value == null) {
            throw new Exception("Mandatory parameter path is missing");
        }
        return value;
    }

    static Pattern pattern(@NotNull SlingHttpServletRequest request, @NotNull Pattern defaultPattern) throws Exception {
        String value = request.getParameter("pattern");
        if (value == null) {
            return defaultPattern;
        }
        try {
            return Pattern.compile(value);
        }
        catch (Exception e) {
            throw new Exception("Invalid parameter value for pattern: " + value);
        }
    }

    static Set<Integer> propertyTypes(@NotNull SlingHttpServletRequest request, @NotNull Set<Integer> defaultPropertyTypes) throws Exception {
        Object[] values = request.getParameterValues("propertyTypes");
        if (values == null || values.length == 0) {
            return defaultPropertyTypes;
        }
        try {
            return ClamUtil.propertyTypesFromNames((String[])values);
        }
        catch (Exception e) {
            throw new Exception("Invalid parameter value for propertyTypes: " + Arrays.toString(values));
        }
    }

    static long maxLength(@NotNull SlingHttpServletRequest request, long defaultMaxLength) throws Exception {
        String value = request.getParameter("maxLength");
        if (value == null) {
            return defaultMaxLength;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new Exception("Invalid parameter value for maxLength: " + value);
        }
    }

    static int maxDepth(@NotNull SlingHttpServletRequest request, int defaultMaxDepth) throws Exception {
        String value = request.getParameter("maxDepth");
        if (value == null) {
            return defaultMaxDepth;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new Exception("Invalid parameter value for maxDepth: " + value);
        }
    }

    static boolean isAuthorized(@NotNull SlingHttpServletRequest request, @NotNull Collection<String> authorizedGroups) throws Exception {
        Authorizable authorizable = (Authorizable)request.getResourceResolver().adaptTo(Authorizable.class);
        if (authorizable == null) {
            return false;
        }
        Iterator groups = authorizable.memberOf();
        while (groups.hasNext()) {
            String id = ((Group)groups.next()).getID();
            if (!authorizedGroups.contains(id)) continue;
            return true;
        }
        return false;
    }
}

