/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.readability;

import java.util.List;
import org.apache.sling.cms.readability.Sentence;

public class Text {
    private final String original;
    private final List<Sentence> sentences;

    public Text(String original, List<Sentence> sentences) {
        this.original = original;
        this.sentences = sentences;
    }

    public int getCharacterCount() {
        return this.sentences.stream().map(Sentence::getCharacterCount).mapToInt(i -> i).sum();
    }

    public int getComplexWordCount() {
        return this.sentences.stream().map(Sentence::getComplexWordCount).mapToInt(i -> i).sum();
    }

    public String getOriginal() {
        return this.original;
    }

    public List<Sentence> getSentences() {
        return this.sentences;
    }

    public int getSyllableCount() {
        return this.sentences.stream().map(Sentence::getSyllableCount).mapToInt(i -> i).sum();
    }

    public int getWordCount() {
        return this.sentences.stream().map(Sentence::getWordCount).mapToInt(i -> i).sum();
    }

    public String toString() {
        return "Text [original=" + this.original + ", sentences=" + this.sentences + ", getCharacterCount()=" + this.getCharacterCount() + ", getComplexWordCount()=" + this.getComplexWordCount() + ", getSyllableCount()=" + this.getSyllableCount() + ", getWordCount()=" + this.getWordCount() + "]";
    }
}

