/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.cms.File;
import org.apache.sling.cms.core.internal.models.PublishableResourceImpl;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class}, adapters={File.class})
public class FileImpl
extends PublishableResourceImpl
implements File {
    private final String contentType = Optional.ofNullable(this.getContentResource()).map(r -> (String)r.getValueMap().get("jcr:mimeType", String.class)).orElse(null);

    @Inject
    public FileImpl(@Self Resource resource) {
        super(resource);
    }

    public String getContentType() {
        return this.contentType;
    }

    public ValueMap getMetadata() {
        Resource metadata = this.getContentResource().getChild("metadata");
        TreeMap data = new TreeMap();
        if (metadata != null) {
            metadata.getValueMap().entrySet().forEach(e -> data.put(Text.unescapeIllegalJcrChars((String)((String)e.getKey())), e.getValue()));
        }
        data.remove("jcr:primaryType");
        return new ValueMapDecorator(data);
    }
}

