/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.sling.commons.log.logback.ConfigProvider;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.StringConfigProvider;
import org.apache.sling.commons.log.logback.internal.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigSourceTracker
extends ServiceTracker<Object, ConfigProvider>
implements LogbackResetListener {
    public static final String PROP_LOGBACK_CONFIG = "logbackConfig";
    private final Map<ServiceReference<Object>, ConfigSourceInfo> inputSources = new ConcurrentSkipListMap(Collections.reverseOrder());
    private final LogConfigManager logConfigManager;

    public ConfigSourceTracker(@NotNull BundleContext context, @NotNull LogConfigManager logConfigManager) throws InvalidSyntaxException {
        super(context, ConfigSourceTracker.createFilter(), null);
        this.logConfigManager = logConfigManager;
    }

    @NotNull
    public Collection<ConfigSourceInfo> getSources() {
        return this.inputSources.values();
    }

    public synchronized void close() {
        super.close();
        this.inputSources.clear();
    }

    @NotNull
    public ConfigProvider addingService(@NotNull ServiceReference<Object> reference) {
        Object o = super.addingService(reference);
        ConfigProvider cp = ConfigSourceTracker.getConfig(o);
        this.inputSources.put(reference, new ConfigSourceInfo(reference, cp));
        this.logConfigManager.configChanged();
        return cp;
    }

    public void modifiedService(@NotNull ServiceReference<Object> reference, @NotNull ConfigProvider service) {
        super.modifiedService(reference, (Object)service);
        this.logConfigManager.configChanged();
    }

    public void removedService(@NotNull ServiceReference<Object> reference, @NotNull ConfigProvider service) {
        this.inputSources.remove(reference);
        this.logConfigManager.configChanged();
    }

    @Override
    public void onResetStart(@NotNull LoggerContext context) {
        context.putObject(ConfigSourceTracker.class.getName(), (Object)this);
    }

    @NotNull
    private static ConfigProvider getConfig(@NotNull Object o) {
        if (o instanceof String) {
            return new StringConfigProvider((String)o);
        }
        return (ConfigProvider)o;
    }

    @NotNull
    private static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(|(objectClass=%s)(&(objectClass=java.lang.String)(%s=*)))", ConfigProvider.class.getName(), PROP_LOGBACK_CONFIG);
        return FrameworkUtil.createFilter((String)filter);
    }

    public static class ConfigSourceInfo {
        private final ServiceReference<Object> reference;
        private final ConfigProvider configProvider;

        public ConfigSourceInfo(@NotNull ServiceReference<Object> reference, @NotNull ConfigProvider configProvider) {
            this.reference = reference;
            this.configProvider = configProvider;
        }

        @NotNull
        public ConfigProvider getConfigProvider() {
            return this.configProvider;
        }

        @NotNull
        public ServiceReference<Object> getReference() {
            return this.reference;
        }

        @NotNull
        public String getSourceAsString() {
            return XmlUtil.prettyPrint(this.getConfigProvider().getConfigSource());
        }

        @NotNull
        public String getSourceAsEscapedString() {
            return XmlUtil.escapeXml(this.getSourceAsString());
        }

        @NotNull
        public String toString() {
            return String.format("Service ID %s", this.reference.getProperty("service.id"));
        }
    }
}

