/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.base.commons.BaseDiscoveryService;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.DefaultTopologyView;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.ViewStateManager;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerFactory;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.spi.base.SyncTokenService;
import org.apache.sling.discovery.commons.providers.util.PropertyNameHelper;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.DiscoveryServiceMBeanImpl;
import org.apache.sling.discovery.impl.cluster.ClusterViewServiceImpl;
import org.apache.sling.discovery.impl.common.heartbeat.HeartbeatHandler;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DiscoveryService.class, DiscoveryServiceImpl.class})
public class DiscoveryServiceImpl
extends BaseDiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryServiceImpl.class);
    private static final ClusterSyncService PASS_THROUGH_CLUSTER_SYNC_SERVICE = new ClusterSyncService(){

        public void sync(BaseTopologyView view, Runnable callback) {
            logger.debug("sync: no syncToken applicable");
            callback.run();
        }

        public void cancelSync() {
        }
    };
    @Reference
    private SlingSettingsService settingsService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=TopologyEventListener.class)
    private TopologyEventListener[] eventListeners = new TopologyEventListener[0];
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=PropertyProvider.class, updated="updatedPropertyProvider")
    private List<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
    private final Object lock = new Object();
    private boolean activated = false;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private HeartbeatHandler heartbeatHandler;
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ConnectorRegistry connectorRegistry;
    @Reference
    private ClusterViewServiceImpl clusterViewService;
    @Reference
    private Config config;
    @Reference
    private SyncTokenService syncTokenService;
    private String slingId;
    private ServiceRegistration mbeanRegistration;
    private ViewStateManager viewStateManager;
    private final ReentrantLock viewStateManagerLock = new ReentrantLock();
    private final List<TopologyEventListener> pendingListeners = new LinkedList<TopologyEventListener>();
    private TopologyEventListener changePropagationListener = new TopologyEventListener(){

        public void handleTopologyEvent(TopologyEvent event) {
            HeartbeatHandler handler = DiscoveryServiceImpl.this.heartbeatHandler;
            if (DiscoveryServiceImpl.this.activated && handler != null && (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.PROPERTIES_CHANGED)) {
                logger.info("changePropagationListener.handleTopologyEvent: topology changed - propagate through connectors");
                handler.triggerAsyncConnectorPing();
            }
        }
    };

    public static BaseDiscoveryService testConstructor(ResourceResolverFactory resourceResolverFactory, AnnouncementRegistry announcementRegistry, ConnectorRegistry connectorRegistry, ClusterViewServiceImpl clusterViewService, HeartbeatHandler heartbeatHandler, SlingSettingsService settingsService, Scheduler scheduler, Config config, SyncTokenService syncTokenServiceOrNull) {
        DiscoveryServiceImpl discoService = new DiscoveryServiceImpl();
        discoService.resourceResolverFactory = resourceResolverFactory;
        discoService.announcementRegistry = announcementRegistry;
        discoService.connectorRegistry = connectorRegistry;
        discoService.clusterViewService = clusterViewService;
        discoService.heartbeatHandler = heartbeatHandler;
        discoService.settingsService = settingsService;
        discoService.scheduler = scheduler;
        discoService.config = config;
        discoService.syncTokenService = syncTokenServiceOrNull;
        return discoService;
    }

    protected void registerMBean(BundleContext bundleContext) {
        if (this.mbeanRegistration != null) {
            try {
                if (this.mbeanRegistration != null) {
                    this.mbeanRegistration.unregister();
                    this.mbeanRegistration = null;
                }
            }
            catch (Exception e) {
                logger.error("registerMBean: Error on unregister: " + e, (Throwable)e);
            }
        }
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=discovery,name=DiscoveryServiceImpl");
            DiscoveryServiceMBeanImpl mbean = new DiscoveryServiceMBeanImpl(this.heartbeatHandler);
            this.mbeanRegistration = bundleContext.registerService(DiscoveryServiceMBeanImpl.class.getName(), (Object)mbean, mbeanProps);
        }
        catch (Throwable t) {
            logger.warn("registerMBean: Unable to register DiscoveryServiceImpl MBean", t);
        }
    }

    protected void handleIsolatedFromTopology() {
        if (this.heartbeatHandler != null && this.heartbeatHandler.resetLeaderElectionId()) {
            logger.info("getTopology: reset leaderElectionId to force this instance to the end of the instance order (thus incl not to remain leader)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(BundleContext bundleContext) {
        ClusterSyncService clusterSyncService;
        logger.debug("DiscoveryServiceImpl activating...");
        if (this.settingsService == null) {
            throw new IllegalStateException("settingsService not found");
        }
        if (this.heartbeatHandler == null) {
            throw new IllegalStateException("heartbeatHandler not found");
        }
        this.slingId = this.settingsService.getSlingId();
        if (!this.config.useSyncTokenService()) {
            logger.info("activate: useSyncTokenService is configured to false. Using pass-through cluster-sync-service.");
            clusterSyncService = PASS_THROUGH_CLUSTER_SYNC_SERVICE;
        } else if (this.syncTokenService == null) {
            logger.warn("activate: useSyncTokenService is configured to true but there's no SyncTokenService! Using pass-through cluster-sync-service instead.");
            clusterSyncService = this.syncTokenService;
        } else {
            logger.info("activate: useSyncTokenService is configured to true, using the available SyncTokenService: " + this.syncTokenService);
            clusterSyncService = this.syncTokenService;
        }
        this.viewStateManager = ViewStateManagerFactory.newViewStateManager((Lock)this.viewStateManagerLock, (ClusterSyncService)clusterSyncService);
        if (this.config.getMinEventDelay() > 0) {
            this.viewStateManager.installMinEventDelayHandler((DiscoveryService)this, this.scheduler, (long)this.config.getMinEventDelay());
        }
        String isolatedClusterId = UUID.randomUUID().toString();
        DefaultClusterView isolatedCluster = new DefaultClusterView(isolatedClusterId);
        HashMap emptyProperties = new HashMap();
        DefaultInstanceDescription isolatedInstance = new DefaultInstanceDescription(isolatedCluster, true, true, this.slingId, emptyProperties);
        ArrayList<DefaultInstanceDescription> col = new ArrayList<DefaultInstanceDescription>();
        col.add(isolatedInstance);
        DefaultTopologyView topology = new DefaultTopologyView();
        topology.addInstances(col);
        topology.setNotCurrent();
        this.setOldView(topology);
        this.setOldView((DefaultTopologyView)this.getTopology());
        this.getOldView().setNotCurrent();
        this.heartbeatHandler.initialize(this, isolatedClusterId);
        this.viewStateManagerLock.lock();
        try {
            this.viewStateManager.handleActivated();
            this.doUpdateProperties();
            DefaultTopologyView newView = (DefaultTopologyView)this.getTopology();
            if (newView.isCurrent()) {
                this.viewStateManager.handleNewView((BaseTopologyView)newView);
            } else {
                logger.info("activate: this instance is in isolated mode and must yet finish voting before it can send out TOPOLOGY_INIT.");
            }
            this.activated = true;
            this.setOldView(newView);
            for (TopologyEventListener listener : this.pendingListeners) {
                this.viewStateManager.bind(listener);
            }
            this.pendingListeners.clear();
            this.viewStateManager.bind(this.changePropagationListener);
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
        URL[] topologyConnectorURLs = this.config.getTopologyConnectorURLs();
        if (topologyConnectorURLs != null) {
            for (int i = 0; i < topologyConnectorURLs.length; ++i) {
                URL aURL = topologyConnectorURLs[i];
                if (aURL == null) continue;
                try {
                    logger.info("activate: registering outgoing topology connector to " + aURL);
                    this.connectorRegistry.registerOutgoingConnector((ClusterViewService)this.clusterViewService, aURL);
                    continue;
                }
                catch (Exception e) {
                    logger.info("activate: could not register url: " + aURL + " due to: " + e, (Throwable)e);
                }
            }
        }
        this.registerMBean(bundleContext);
        logger.debug("DiscoveryServiceImpl activated.");
    }

    @Deactivate
    protected void deactivate() {
        logger.debug("DiscoveryServiceImpl deactivated.");
        this.viewStateManagerLock.lock();
        try {
            if (this.viewStateManager != null) {
                this.viewStateManager.unbind(this.changePropagationListener);
                this.viewStateManager.handleDeactivated();
            }
            this.activated = false;
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
        try {
            if (this.mbeanRegistration != null) {
                this.mbeanRegistration.unregister();
                this.mbeanRegistration = null;
            }
        }
        catch (Exception e) {
            logger.error("deactivate: Error on unregister: " + e, (Throwable)e);
        }
    }

    protected void bindTopologyEventListener(TopologyEventListener eventListener) {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                this.pendingListeners.add(eventListener);
            } else {
                this.viewStateManager.bind(eventListener);
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    protected void unbindTopologyEventListener(TopologyEventListener eventListener) {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                this.pendingListeners.remove(eventListener);
            } else {
                this.viewStateManager.unbind(eventListener);
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Binding PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    private void bindPropertyProviderInteral(PropertyProvider propertyProvider, Map<String, Object> props) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        this.providerInfos.add(info);
        Collections.sort(this.providerInfos);
        this.doUpdateProperties();
        this.checkForTopologyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("bindPropertyProvider: Updating PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, false);
            this.bindPropertyProviderInteral(propertyProvider, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        logger.debug("unbindPropertyProvider: Releasing PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            this.unbindPropertyProviderInternal(propertyProvider, props, true);
        }
    }

    private void unbindPropertyProviderInternal(PropertyProvider propertyProvider, Map<String, Object> props, boolean update) {
        ProviderInfo info = new ProviderInfo(propertyProvider, props);
        if (this.providerInfos.remove(info) && update) {
            this.doUpdateProperties();
            this.checkForTopologyChange();
        }
    }

    private void doUpdateProperties() {
        if (this.resourceResolverFactory == null) {
            logger.debug("doUpdateProperties: too early to update the properties. resourceResolverFactory not yet set.");
            return;
        }
        logger.debug("doUpdateProperties: updating properties now..");
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (ProviderInfo info : this.providerInfos) {
            info.refreshProperties();
            newProps.putAll(info.properties);
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            Resource myInstance = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(this.config.getClusterInstancesPath() + "/" + this.slingId + "/properties"));
            resourceResolver.revert();
            resourceResolver.refresh();
            ModifiableValueMap myInstanceMap = (ModifiableValueMap)myInstance.adaptTo(ModifiableValueMap.class);
            HashSet keys = new HashSet(myInstanceMap.keySet());
            for (String key : keys) {
                if (newProps.containsKey(key) || key.indexOf(":") != -1) continue;
                myInstanceMap.remove((Object)key);
            }
            boolean anyChanges = false;
            for (Map.Entry entry : newProps.entrySet()) {
                Object existingValue = myInstanceMap.get(entry.getKey());
                if (((String)entry.getValue()).equals(existingValue)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("doUpdateProperties: unchanged: {}={}", entry.getKey(), entry.getValue());
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doUpdateProperties: changed: {}={}", entry.getKey(), entry.getValue());
                }
                anyChanges = true;
                myInstanceMap.put(entry.getKey(), entry.getValue());
            }
            if (anyChanges) {
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        logger.debug("doUpdateProperties: updating properties done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties() {
        Object object = this.lock;
        synchronized (object) {
            logger.debug("updateProperties: calling doUpdateProperties.");
            this.doUpdateProperties();
            logger.debug("updateProperties: calling handlePotentialTopologyChange.");
            this.checkForTopologyChange();
            logger.debug("updateProperties: done.");
        }
    }

    public void checkForLocalClusterViewChange() {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                logger.debug("checkForLocalClusterViewChange: not yet activated, ignoring");
                return;
            }
            try {
                ClusterViewService clusterViewService = this.getClusterViewService();
                if (clusterViewService == null) {
                    throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "no ClusterViewService available at the moment");
                }
                LocalClusterView localClusterView = clusterViewService.getLocalClusterView();
            }
            catch (UndefinedClusterViewException e) {
                logger.info("checkForLocalClusterViewChange: undefined cluster view: " + e.getReason() + "] " + (Object)((Object)e));
                this.getOldView().setNotCurrent();
                this.viewStateManager.handleChanging();
                if (e.getReason() == UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY) {
                    this.handleIsolatedFromTopology();
                }
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    public void checkForTopologyChange() {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                logger.debug("checkForTopologyChange: not yet activated, ignoring");
                return;
            }
            DefaultTopologyView t = (DefaultTopologyView)this.getTopology();
            if (t.isCurrent()) {
                this.viewStateManager.handleNewView((BaseTopologyView)t);
                this.setOldView(t);
            } else {
                this.viewStateManager.handleChanging();
            }
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    public void handleTopologyChanging() {
        this.viewStateManagerLock.lock();
        try {
            if (!this.activated) {
                logger.error("handleTopologyChanging: not yet activated!");
                return;
            }
            logger.debug("handleTopologyChanging: invoking viewStateManager.handlechanging");
            this.viewStateManager.handleChanging();
        }
        finally {
            if (this.viewStateManagerLock != null) {
                this.viewStateManagerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcedShutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activated) {
                logger.error("forcedShutdown: ignoring forced shutdown. Service is not activated.");
                return;
            }
            if (this.getOldView() == null) {
                logger.error("forcedShutdown: ignoring forced shutdown. No oldView available.");
                return;
            }
            logger.error("forcedShutdown: sending TOPOLOGY_CHANGING to all listeners");
            this.getOldView().setNotCurrent();
            this.viewStateManager.handleChanging();
            logger.error("forcedShutdown: deactivating DiscoveryService.");
            this.activated = false;
        }
    }

    protected ClusterViewService getClusterViewService() {
        return this.clusterViewService;
    }

    public ClusterViewServiceImpl getClusterViewServiceImpl() {
        return this.clusterViewService;
    }

    protected AnnouncementRegistry getAnnouncementRegistry() {
        return this.announcementRegistry;
    }

    protected ViewStateManager getViewStateManager() {
        return this.viewStateManager;
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        this.heartbeatHandler = heartbeatHandler;
    }

    protected void unbindHeartbeatHandler(HeartbeatHandler heartbeatHandler) {
        if (this.heartbeatHandler == heartbeatHandler) {
            this.heartbeatHandler = null;
        }
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        this.connectorRegistry = connectorRegistry;
    }

    protected void unbindConnectorRegistry(ConnectorRegistry connectorRegistry) {
        if (this.connectorRegistry == connectorRegistry) {
            this.connectorRegistry = null;
        }
    }

    protected void bindClusterViewService(ClusterViewServiceImpl clusterViewServiceImpl) {
        this.clusterViewService = clusterViewServiceImpl;
    }

    protected void unbindClusterViewService(ClusterViewServiceImpl clusterViewServiceImpl) {
        if (this.clusterViewService == clusterViewServiceImpl) {
            this.clusterViewService = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindSyncTokenService(SyncTokenService syncTokenService) {
        this.syncTokenService = syncTokenService;
    }

    protected void unbindSyncTokenService(SyncTokenService syncTokenService) {
        if (this.syncTokenService == syncTokenService) {
            this.syncTokenService = null;
        }
    }

    private static final class ProviderInfo
    implements Comparable<ProviderInfo> {
        public final PropertyProvider provider;
        public final Object propertyProperties;
        public final int ranking;
        public final long serviceId;
        public final Map<String, String> properties = new HashMap<String, String>();

        public ProviderInfo(PropertyProvider provider, Map<String, Object> serviceProps) {
            this.provider = provider;
            this.propertyProperties = serviceProps.get("instance.properties");
            Object sr = serviceProps.get("service.ranking");
            this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
            this.serviceId = (Long)serviceProps.get("service.id");
            this.refreshProperties();
        }

        public void refreshProperties() {
            this.properties.clear();
            if (this.propertyProperties instanceof String) {
                String val = this.provider.getProperty((String)this.propertyProperties);
                if (val != null) {
                    this.putPropertyIfValid((String)this.propertyProperties, val);
                }
            } else if (this.propertyProperties instanceof String[]) {
                for (String name : (String[])this.propertyProperties) {
                    String val = this.provider.getProperty(name);
                    if (val == null) continue;
                    this.putPropertyIfValid(name, val);
                }
            }
        }

        private void putPropertyIfValid(String name, String val) {
            if (PropertyNameHelper.isValidPropertyName((String)name)) {
                this.properties.put(name, val);
            }
        }

        @Override
        public int compareTo(ProviderInfo o) {
            if (this.ranking < o.ranking) {
                return -1;
            }
            if (this.ranking > o.ranking) {
                return 1;
            }
            return this.serviceId < o.serviceId ? 1 : -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProviderInfo) {
                return ((ProviderInfo)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            return this.provider.hashCode();
        }
    }
}

