/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.HashSet;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.agent.impl.AbstractDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.monitor.impl.SimpleDistributionAgentMBean;
import org.apache.sling.distribution.monitor.impl.SimpleDistributionAgentMBeanImpl;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.SingleQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingDistributionQueueProvider;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=Agent name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class SimpleDistributionAgentFactory
extends AbstractDistributionAgentFactory<SimpleDistributionAgentMBean> {
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String DETAILS = "details";
    private static final String SERVICE_NAME = "serviceName";
    private static final String QUEUE_PROCESSING_ENABLED = "queue.processing.enabled";
    @Reference(name="packageExporter")
    private DistributionPackageExporter packageExporter;
    @Reference(name="packageImporter")
    private DistributionPackageImporter packageImporter;
    @Reference(name="requestAuthorizationStrategy")
    private DistributionRequestAuthorizationStrategy requestAuthorizationStrategy;
    public static final String TRIGGERS_TARGET = "triggers.target";
    @Reference
    private DistributionEventFactory distributionEventFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository slingRepository;

    public SimpleDistributionAgentFactory() {
        super(SimpleDistributionAgentMBean.class);
    }

    @Override
    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        super.activate(context, config);
    }

    @Override
    @Reference(name="triggers", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindDistributionTrigger", unbind="unbindDistributionTrigger")
    protected void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.bindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    protected void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.unbindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext context) {
        super.deactivate(context);
    }

    @Override
    protected SimpleDistributionAgent createAgent(String agentName, BundleContext context, Map<String, Object> config, DefaultDistributionLog distributionLog) {
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        boolean queueProcessingEnabled = PropertiesUtil.toBoolean((Object)config.get(QUEUE_PROCESSING_ENABLED), (boolean)true);
        JobHandlingDistributionQueueProvider queueProvider = new JobHandlingDistributionQueueProvider(agentName, this.jobManager, context);
        SingleQueueDispatchingStrategy exportQueueStrategy = new SingleQueueDispatchingStrategy();
        DistributionQueueDispatchingStrategy importQueueStrategy = null;
        HashSet<String> processingQueues = new HashSet<String>();
        processingQueues.addAll(exportQueueStrategy.getQueueNames());
        return new SimpleDistributionAgent(agentName, queueProcessingEnabled, processingQueues, serviceName, this.packageImporter, this.packageExporter, this.requestAuthorizationStrategy, queueProvider, exportQueueStrategy, importQueueStrategy, this.distributionEventFactory, this.resourceResolverFactory, this.slingRepository, distributionLog, null, null, 0);
    }

    @Override
    protected SimpleDistributionAgentMBean createMBeanAgent(DistributionAgent agent, Map<String, Object> osgiConfiguration) {
        return new SimpleDistributionAgentMBeanImpl(agent, osgiConfiguration);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Agent - Simple Agents Factory", description="OSGi configuration factory for agents")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the agent.")
        public String name() default "";

        @AttributeDefinition(name="Title", description="The display friendly title of the agent.")
        public String title() default "";

        @AttributeDefinition(name="Details", description="The display friendly details of the agent.")
        public String details() default "";

        @AttributeDefinition(name="Enabled", description="Whether or not to start the distribution agent.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
        public String serviceName() default "";

        @AttributeDefinition(name="Log Level", description="The log level recorded in the transient log accessible via http.", options={@Option(label="debug", value="debug"), @Option(label="info", value="info"), @Option(label="warn", value="warn"), @Option(label="error", value="error")})
        public String log_level() default "info";

        @AttributeDefinition(name="Queue Processing Enabled", description="Whether or not the distribution agent should process packages in the queues.")
        public boolean queue_processing_enabled() default true;

        @AttributeDefinition(name="Exporter", description="The target reference for the DistributionPackageExporter used to receive (export) the distribution packages,\" +\n            \"e.g. use target=(name=...) to bind to services by name.")
        public String packageExporter_target();

        @AttributeDefinition(name="Importer", description="The target reference for the DistributionPackageImporter used to send (import) the distribution packages,e.g. use target=(name=...) to bind to services by name.")
        public String packageImporter_target();

        @AttributeDefinition(name="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.")
        public String requestAuthorizationStrategy_target();

        @AttributeDefinition(name="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
        public String triggers_target() default "(name=)";
    }
}

