/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.sling.distribution.journal.impl.subscriber.IdleCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SubscriberIdleCheck
implements HealthCheck,
Closeable {
    static final String CHECK_NAME = "DistributionSubscriber idle";
    private final ServiceRegistration<HealthCheck> reg;
    private final IdleCheck idleCheck;

    public SubscriberIdleCheck(BundleContext context, IdleCheck idleCheck) {
        this.idleCheck = idleCheck;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("hc.name", CHECK_NAME);
        this.reg = context.registerService(HealthCheck.class, (Object)this, props);
    }

    public Result execute() {
        Result.Status status = this.idleCheck.isIdle() ? Result.Status.OK : Result.Status.TEMPORARILY_UNAVAILABLE;
        return new Result(status, CHECK_NAME);
    }

    @Override
    public void close() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }
}

