/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.sling.distribution.journal.ExceptionEventSender;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaJsonMessageSender<T>
implements MessageSender<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaJsonMessageSender.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final KafkaProducer<String, String> producer;
    private final ExceptionEventSender eventSender;
    private final String topic;

    public KafkaJsonMessageSender(KafkaProducer<String, String> producer, String topic, ExceptionEventSender eventSender) {
        this.topic = topic;
        this.eventSender = eventSender;
        this.producer = Objects.requireNonNull(producer);
    }

    public void send(T payload) throws MessagingException {
        this.send(payload, Collections.emptyMap());
    }

    public void send(T payload, Map<String, String> properties) throws MessagingException {
        try {
            ObjectWriter writer = this.mapper.writerFor(payload.getClass());
            String payloadSt = writer.writeValueAsString(payload);
            List headerList = properties.entrySet().stream().map(this::toHeader).collect(Collectors.toList());
            RecordHeader messageType = this.header("messageType", payload.getClass().getSimpleName());
            headerList.add(messageType);
            ProducerRecord record = new ProducerRecord(this.topic, Integer.valueOf(0), null, (Object)payloadSt, headerList);
            RecordMetadata metadata = (RecordMetadata)this.producer.send(record).get();
            LOG.info("Sent to topic={}, offset={}", (Object)this.topic, (Object)metadata.offset());
        }
        catch (Exception e) {
            this.eventSender.send(e);
            throw new MessagingException(String.format("Failed to send JSON message on topic %s", this.topic), e);
        }
    }

    private Header toHeader(Map.Entry<String, String> entry) {
        return this.header(entry.getKey(), entry.getValue());
    }

    private RecordHeader header(String key, String value) {
        return new RecordHeader(key, value.getBytes(StandardCharsets.UTF_8));
    }
}

