/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.DispatchingInfo;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRequestDispatcher
implements RequestDispatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Resource resource;
    private final RequestDispatcherOptions options;
    private final String path;
    private final boolean protectHeadersOnInclude;
    private final boolean checkContentTypeOnInclude;

    public SlingRequestDispatcher(String path, RequestDispatcherOptions options, boolean protectHeadersOnInclude, boolean checkContentTypeOnInclude) {
        this.path = path;
        this.options = options;
        this.resource = null;
        this.protectHeadersOnInclude = protectHeadersOnInclude;
        this.checkContentTypeOnInclude = checkContentTypeOnInclude;
    }

    public SlingRequestDispatcher(Resource resource, RequestDispatcherOptions options, boolean protectHeadersOnInclude, boolean checkContentTypeOnInclude) {
        this.resource = resource;
        this.options = options;
        this.path = resource.getPath();
        this.protectHeadersOnInclude = protectHeadersOnInclude;
        this.checkContentTypeOnInclude = checkContentTypeOnInclude;
    }

    public void include(ServletRequest request, ServletResponse sResponse) throws ServletException, IOException {
        ContentData cd;
        try {
            cd = RequestData.getRequestData(request).getContentData();
        }
        catch (IllegalArgumentException iae) {
            throw new ServletException(iae.getMessage());
        }
        HttpServletRequest hRequest = (HttpServletRequest)request;
        DispatchingInfo info = new DispatchingInfo(DispatcherType.INCLUDE);
        info.setRequestContent(cd.getResource());
        info.setRequestServlet(cd.getServlet());
        info.setRequestPathInfo(cd.getRequestPathInfo());
        info.setContextPath(hRequest.getContextPath());
        info.setPathInfo(hRequest.getPathInfo());
        info.setQueryString(hRequest.getQueryString());
        info.setRequestUri(hRequest.getRequestURI());
        info.setServletPath(hRequest.getServletPath());
        this.dispatch(request, sResponse, info);
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        response.resetBuffer();
        DispatchingInfo info = new DispatchingInfo(DispatcherType.FORWARD);
        this.dispatch(request, response, info);
        if (!response.isCommitted()) {
            response.flushBuffer();
        }
    }

    private String getAbsolutePath(SlingHttpServletRequest request, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String uri = request.getResource().getPath();
        int lastSlash = uri.lastIndexOf(47);
        if (lastSlash >= 0) {
            uri = uri.substring(0, lastSlash);
        }
        return uri + '/' + path;
    }

    private void dispatch(ServletRequest request, ServletResponse response, DispatchingInfo dispatchingInfo) throws ServletException, IOException {
        SlingHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData rd = RequestData.getRequestData(cRequest);
        String absPath = this.getAbsolutePath(cRequest, this.path);
        RequestProgressTracker requestProgressTracker = cRequest.getRequestProgressTracker();
        if (!(response instanceof HttpServletResponse)) {
            this.log.error("include: Failed to include {}, response has wrong type", (Object)absPath);
            return;
        }
        if (this.resource == null) {
            String timerName = "resolveIncludedResource(" + absPath + ")";
            requestProgressTracker.startTimer(timerName);
            this.resource = cRequest.getResourceResolver().resolve(absPath);
            if (this.resource == null) {
                this.log.error("include: Could not resolve {} to a resource, not including", (Object)absPath);
                return;
            }
            requestProgressTracker.logTimer(timerName, "path={0} resolves to Resource={1}", new Object[]{absPath, this.resource});
        }
        SlingRequestPathInfo info = this.getMergedRequestPathInfo(cRequest);
        requestProgressTracker.log("Including resource {0} ({1})", new Object[]{this.resource, info});
        if (dispatchingInfo.getType() == DispatcherType.INCLUDE) {
            boolean protectHeaders = this.options != null ? Boolean.parseBoolean((String)this.options.getOrDefault((Object)"protectHeadersOnInclude", (Object)String.valueOf(this.protectHeadersOnInclude))) : this.protectHeadersOnInclude;
            dispatchingInfo.setProtectHeadersOnInclude(protectHeaders);
            dispatchingInfo.setCheckContentTypeOnInclude(this.checkContentTypeOnInclude);
        }
        rd.getSlingRequestProcessor().dispatchRequest(request, response, this.resource, info, dispatchingInfo);
    }

    private SlingRequestPathInfo getMergedRequestPathInfo(SlingHttpServletRequest cRequest) {
        SlingRequestPathInfo info = new SlingRequestPathInfo(this.resource);
        info = info.merge(cRequest.getRequestPathInfo());
        if (this.options != null) {
            info = info.merge(this.options);
            String rtOverwrite = this.options.getForceResourceType();
            if (rtOverwrite != null && !rtOverwrite.equals(this.resource.getResourceType())) {
                this.resource = new TypeOverwritingResourceWrapper(this.resource, rtOverwrite);
            }
        }
        return info;
    }

    private static class TypeOverwritingResourceWrapper
    extends ResourceWrapper {
        private final String resourceType;

        TypeOverwritingResourceWrapper(Resource delegatee, String resourceType) {
            super(delegatee);
            this.resourceType = resourceType;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getResourceSuperType() {
            return null;
        }

        public boolean isResourceType(String resourceType) {
            return this.getResourceResolver().isResourceType((Resource)this, resourceType);
        }
    }
}

