/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sling.feature.analyser.Analyser;
import org.apache.sling.feature.analyser.task.AnalyserTask;

public final class AnalyzerTaskProvider {
    private AnalyzerTaskProvider() {
    }

    public static AnalyserTask[] getTasks() {
        return AnalyzerTaskProvider.getTasksByIds(null, null);
    }

    public static AnalyserTask[] getTasksByIds(Set<String> includes, Set<String> excludes) {
        if (excludes == null) {
            excludes = Collections.emptySet();
        }
        ServiceLoader<AnalyserTask> loader = ServiceLoader.load(AnalyserTask.class);
        HashSet<String> foundTasks = new HashSet<String>();
        ArrayList<AnalyserTask> list = new ArrayList<AnalyserTask>();
        for (AnalyserTask task : loader) {
            boolean included = includes != null ? includes.contains(task.getId()) : true;
            boolean excluded = excludes.contains(task.getId());
            if (!included || excluded) continue;
            list.add(task);
            foundTasks.add(task.getId());
        }
        HashSet<String> notFoundTasks = new HashSet<String>(includes != null ? includes : Collections.emptySet());
        notFoundTasks.removeAll(foundTasks);
        notFoundTasks.removeAll(excludes);
        if (notFoundTasks.size() > 0) {
            throw new IllegalStateException("Configured analyser task(s) not found: " + notFoundTasks);
        }
        return list.toArray(new AnalyserTask[list.size()]);
    }

    public static AnalyserTask[] getTasksByClassName(String ... taskClassNames) throws IOException {
        if (taskClassNames == null) {
            throw new IOException("Impossible to load Tasks from a null string array");
        }
        ArrayList<AnalyserTask> list = new ArrayList<AnalyserTask>();
        for (String cls : taskClassNames) {
            try {
                AnalyserTask task = (AnalyserTask)Analyser.class.getClassLoader().loadClass(cls).newInstance();
                list.add(task);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return list.toArray(new AnalyserTask[list.size()]);
    }
}

