/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import com.google.inject.Key;
import java.util.Map;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.ServiceRegistry;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.builders.DecoratedServiceBuilder;
import org.ops4j.peaberry.builders.ExportProvider;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.builders.ProxyProvider;
import org.ops4j.peaberry.internal.ExportedServiceProvider;
import org.ops4j.peaberry.internal.MultipleServiceProvider;
import org.ops4j.peaberry.internal.ServiceSettings;
import org.ops4j.peaberry.internal.Setting;
import org.ops4j.peaberry.internal.SingleServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceBuilderImpl<T>
implements DecoratedServiceBuilder<T> {
    private final ServiceSettings<T> settings;

    public ServiceBuilderImpl(Key<T> key) {
        this.settings = new ServiceSettings<Key<T>>(key);
    }

    public ServiceBuilderImpl(T instance) {
        this.settings = new ServiceSettings<T>(instance);
    }

    @Override
    public ServiceBuilderImpl<T> decoratedWith(Key<? extends ImportDecorator<? super T>> key) {
        this.settings.setDecorator(Setting.newSetting(key));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> decoratedWith(ImportDecorator<? super T> instance) {
        this.settings.setDecorator(Setting.newSetting(instance));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> attributes(Key<? extends Map<String, ?>> key) {
        this.settings.setAttributes(Setting.newSetting(key));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> attributes(Map<String, ?> instance) {
        this.settings.setAttributes(Setting.newSetting(instance));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> filter(Key<? extends AttributeFilter> key) {
        this.settings.setFilter(Setting.newSetting(key));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> filter(AttributeFilter instance) {
        this.settings.setFilter(Setting.newSetting(instance));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> in(Key<? extends ServiceRegistry> key) {
        this.settings.setRegistry(Setting.newSetting(key));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> in(ServiceRegistry instance) {
        this.settings.setRegistry(Setting.newSetting(instance));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> out(Key<? extends ServiceWatcher<? super T>> key) {
        this.settings.setWatcher(Setting.newSetting(key));
        return this;
    }

    @Override
    public ServiceBuilderImpl<T> out(ServiceWatcher<? super T> instance) {
        this.settings.setWatcher(Setting.newSetting(instance));
        return this;
    }

    @Override
    public ProxyProvider<T> single() {
        return new SingleServiceProvider<T>(this.settings);
    }

    @Override
    public ProxyProvider<Iterable<T>> multiple() {
        return new MultipleServiceProvider<T>(this.settings);
    }

    @Override
    public ExportProvider<T> export() {
        return new ExportedServiceProvider<T>(this.settings);
    }
}

