/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.http.impl.client;

import relocated_for_contentpackage.org.apache.http.HeaderElement;
import relocated_for_contentpackage.org.apache.http.HttpResponse;
import relocated_for_contentpackage.org.apache.http.annotation.Contract;
import relocated_for_contentpackage.org.apache.http.annotation.ThreadingBehavior;
import relocated_for_contentpackage.org.apache.http.conn.ConnectionKeepAliveStrategy;
import relocated_for_contentpackage.org.apache.http.message.BasicHeaderElementIterator;
import relocated_for_contentpackage.org.apache.http.protocol.HttpContext;
import relocated_for_contentpackage.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

