/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config;

import java.io.ByteArrayOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import relocated_for_contentpackage.javax.jcr.Credentials;
import relocated_for_contentpackage.javax.jcr.SimpleCredentials;
import relocated_for_contentpackage.org.apache.jackrabbit.util.Text;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.CredentialsConfig;

public class SimpleCredentialsConfig
extends CredentialsConfig {
    private static final int KEY_LENGTH = 8;
    private static final String PREFIX = "{DES}";
    private static final Logger log = LoggerFactory.getLogger(SimpleCredentialsConfig.class);
    private final SimpleCredentials creds;
    public static final String ELEM_USER = "user";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PASSWORD = "password";

    public SimpleCredentialsConfig(SimpleCredentials creds) {
        super("simple");
        this.creds = creds;
    }

    @Override
    public Credentials getCredentials() {
        return this.creds;
    }

    public static SimpleCredentialsConfig load(Element elem) throws ConfigurationException {
        assert (elem.getNodeName().equals("credentials"));
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(ELEM_USER)) continue;
            Element e = (Element)child;
            String name = e.getAttribute(ATTR_NAME);
            String pass = SimpleCredentialsConfig.decrypt(e.getAttribute(ATTR_PASSWORD));
            return new SimpleCredentialsConfig(new SimpleCredentials(name, pass == null ? new char[]{} : pass.toCharArray()));
        }
        throw new ConfigurationException("mandatory element <user> missing.");
    }

    @Override
    @Deprecated
    public void writeInner(ContentHandler handler) throws SAXException {
        throw new UnsupportedOperationException("No longer supports write with a SAX contentHandler, user write with XMLStreamWriter instead!");
    }

    @Override
    protected void writeInner(XMLStreamWriter writer) throws XMLStreamException {
        if (this.creds != null) {
            writer.writeStartElement(ELEM_USER);
            writer.writeAttribute(ATTR_NAME, this.creds.getUserID());
            writer.writeAttribute(ATTR_PASSWORD, SimpleCredentialsConfig.encrypt(new String(this.creds.getPassword())));
            writer.writeEndElement();
        }
    }

    private static String encrypt(String s) {
        try {
            SecretKey key = KeyGenerator.getInstance("DES").generateKey();
            Cipher cipher = Cipher.getInstance("DES");
            byte[] keyBytes = key.getEncoded();
            byte[] data = s.getBytes("utf-8");
            ByteArrayOutputStream out = new ByteArrayOutputStream(keyBytes.length + data.length);
            out.write(keyBytes);
            cipher.init(1, key);
            out.write(cipher.update(data));
            out.write(cipher.doFinal());
            StringBuilder ret = new StringBuilder(PREFIX);
            for (byte b : out.toByteArray()) {
                ret.append(Text.hexTable[b >> 4 & 0xF]).append(Text.hexTable[b & 0xF]);
            }
            return ret.toString();
        }
        catch (Exception e) {
            log.warn("Unable to encrypt string: " + e);
            return null;
        }
    }

    private static String decrypt(String s) {
        String string;
        if (s == null || !s.startsWith(PREFIX)) {
            return s;
        }
        byte[] data = new byte[(s.length() - PREFIX.length()) / 2];
        int i = PREFIX.length();
        int b = 0;
        while (i < s.length()) {
            data[b] = (byte)(Integer.parseInt(s.substring(i, i + 2), 16) & 0xFF);
            i += 2;
            ++b;
        }
        SecretKeySpec key = new SecretKeySpec(data, 0, 8, "DES");
        Cipher cipher = Cipher.getInstance("DES");
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        try {
            cipher.init(2, key);
            out.write(cipher.update(data, 8, data.length - 8));
            out.write(cipher.doFinal());
            string = out.toString("utf-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.warn("Unable to decrypt data: " + e);
                return null;
            }
        }
        out.close();
        return string;
    }
}

