/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.NodeIterator;
import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportMode;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.NodeStash;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.DocViewNode;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.DocViewProperty;

public class JcrSysViewTransformer
implements DocViewAdapter {
    private static final Logger log = LoggerFactory.getLogger(JcrSysViewTransformer.class);
    private ContentHandler handler;
    private NodeStash recovery;
    private String rootName;
    private Node parent;
    private final String existingPath;
    private final Set<String> excludedNodeNames = new HashSet<String>();
    private long ignoreLevel = 0L;

    public JcrSysViewTransformer(@NotNull Node node, @NotNull ImportMode importMode) throws SAXException, RepositoryException {
        this(node, null, importMode);
    }

    JcrSysViewTransformer(@NotNull Node node, @Nullable String existingPath, @NotNull ImportMode importMode) throws RepositoryException, SAXException {
        Session session = node.getSession();
        this.parent = node;
        this.handler = session.getImportContentHandler(node.getPath(), existingPath != null ? 2 : 1);
        String[] prefixes = session.getNamespacePrefixes();
        this.handler.startDocument();
        for (String prefix : prefixes) {
            this.handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
        }
        this.existingPath = existingPath;
        if (existingPath != null) {
            this.recovery = new NodeStash(session, existingPath, importMode).excludeName("rep:cache");
            this.recovery.stash();
        }
        this.excludeNode("rep:cache");
    }

    @Override
    public List<String> close() throws SAXException {
        this.handler.endDocument();
        ArrayList<String> paths = new ArrayList<String>();
        try {
            if (this.existingPath != null && this.parent.getSession().nodeExists(this.existingPath)) {
                this.addPaths(paths, this.parent.getSession().getNode(this.existingPath));
            } else if (this.rootName != null && this.parent.hasNode(this.rootName)) {
                this.addPaths(paths, this.parent.getNode(this.rootName));
            }
        }
        catch (RepositoryException e) {
            log.error("error while retrieving list of created nodes.");
        }
        if (this.recovery != null) {
            try {
                this.recovery.recover(null);
            }
            catch (RepositoryException e) {
                log.error("Error while processing rescued child nodes");
            }
            finally {
                this.recovery = null;
            }
        }
        return paths;
    }

    private void addPaths(List<String> paths, Node node) throws RepositoryException {
        paths.add(node.getPath());
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.addPaths(paths, iter.nextNode());
        }
    }

    @Override
    public void startNode(DocViewNode ni) throws SAXException {
        if (this.ignoreLevel > 0L) {
            DocViewSAXImporter.log.trace("ignoring child node of excluded node: {}", (Object)ni.name);
            ++this.ignoreLevel;
            return;
        }
        if (this.excludedNodeNames.contains(ni.name)) {
            DocViewSAXImporter.log.trace("Ignoring excluded node {}", (Object)ni.name);
            this.ignoreLevel = 1L;
            return;
        }
        DocViewSAXImporter.log.trace("Transforming element to sysview {}", (Object)ni.name);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
        this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
        for (DocViewProperty p : ni.props.values()) {
            if (p == null || p.values == null) continue;
            attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue(p.type));
            if (p.isMulti) {
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "multiple", "sv:multiple", "CDATA", "true");
            }
            this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
            for (String v : p.values) {
                this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", DocViewSAXImporter.EMPTY_ATTRIBUTES);
                this.handler.characters(v.toCharArray(), 0, v.length());
                this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
            }
            this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
        }
        if (this.rootName == null) {
            this.rootName = ni.name;
        }
    }

    @Override
    public void endNode() throws SAXException {
        if (this.ignoreLevel > 0L) {
            --this.ignoreLevel;
            return;
        }
        this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
    }

    public JcrSysViewTransformer excludeNode(String name) {
        this.excludedNodeNames.add(name);
        return this;
    }
}

