/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.impl.felix.utils.resource;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.feature.impl.felix.utils.resource.CapabilityImpl;
import org.apache.sling.feature.impl.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.impl.felix.utils.resource.ResourceBuilder;
import org.apache.sling.feature.impl.felix.utils.resource.SimpleFilter;
import org.apache.sling.feature.impl.felix.utils.version.VersionTable;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class CapabilitySet {
    private static final Class<?>[] STRING_CLASS = new Class[]{String.class};
    private final Map<String, Map<Object, Set<Capability>>> indices;
    private final Set<Capability> capSet = new HashSet<Capability>();

    public CapabilitySet(List<String> indexProps) {
        this.indices = new TreeMap<String, Map<Object, Set<Capability>>>();
        for (int i = 0; indexProps != null && i < indexProps.size(); ++i) {
            this.indices.put(indexProps.get(i), new HashMap());
        }
    }

    public void dump() {
        for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.indices.entrySet()) {
            boolean header1 = false;
            for (Map.Entry<Object, Set<Capability>> entry2 : entry.getValue().entrySet()) {
                boolean header2 = false;
                for (Capability cap : entry2.getValue()) {
                    if (!header1) {
                        System.out.println(entry.getKey() + ":");
                        header1 = true;
                    }
                    if (!header2) {
                        System.out.println("   " + entry2.getKey());
                        header2 = true;
                    }
                    System.out.println("      " + cap);
                }
            }
        }
    }

    public void addCapability(Capability cap) {
        this.capSet.add(cap);
        for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.indices.entrySet()) {
            Object value = cap.getAttributes().get(entry.getKey());
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CapabilitySet.convertArrayToList(value);
            }
            Map<Object, Set<Capability>> index = entry.getValue();
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                for (Object o : c) {
                    this.indexCapability(index, cap, o);
                }
                continue;
            }
            this.indexCapability(index, cap, value);
        }
    }

    private void indexCapability(Map<Object, Set<Capability>> index, Capability cap, Object capValue) {
        Set<Capability> set = index.get(capValue);
        if (set == null) {
            set = new HashSet<Capability>();
            index.put(capValue, set);
        }
        set.add(cap);
    }

    public void removeCapability(Capability cap) {
        if (this.capSet.remove(cap)) {
            for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.indices.entrySet()) {
                Object value = cap.getAttributes().get(entry.getKey());
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    value = CapabilitySet.convertArrayToList(value);
                }
                Map<Object, Set<Capability>> index = entry.getValue();
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object o : c) {
                        this.deindexCapability(index, cap, o);
                    }
                    continue;
                }
                this.deindexCapability(index, cap, value);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<Capability>> index, Capability cap, Object value) {
        Set<Capability> caps = index.get(value);
        if (caps != null) {
            caps.remove(cap);
            if (caps.isEmpty()) {
                index.remove(value);
            }
        }
    }

    public Set<Capability> match(SimpleFilter sf, boolean obeyMandatory) {
        Set<Capability> matches = this.match(this.capSet, sf);
        return obeyMandatory ? CapabilitySet.matchMandatory(matches, sf) : matches;
    }

    private Set<Capability> match(Set<Capability> caps, SimpleFilter sf) {
        Set<Capability> matches;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                matches = new HashSet<Capability>();
                                if (sf.getOperation() != 0) break block4;
                                matches.addAll(caps);
                                break block5;
                            }
                            if (sf.getOperation() != 1) break block6;
                            List sfs = (List)sf.getValue();
                            for (int i = 0; caps.size() > 0 && i < sfs.size(); ++i) {
                                matches = this.match(caps, (SimpleFilter)sfs.get(i));
                                caps = matches;
                            }
                            break block5;
                        }
                        if (sf.getOperation() != 2) break block7;
                        List sfs = (List)sf.getValue();
                        for (SimpleFilter sf1 : sfs) {
                            matches.addAll(this.match(caps, sf1));
                        }
                        break block5;
                    }
                    if (sf.getOperation() != 3) break block8;
                    matches.addAll(caps);
                    List sfs = (List)sf.getValue();
                    for (SimpleFilter sf1 : sfs) {
                        matches.removeAll(this.match(caps, sf1));
                    }
                    break block5;
                }
                Map<Object, Set<Capability>> index = this.indices.get(sf.getName());
                if (sf.getOperation() != 4 || index == null) break block9;
                Set<Capability> existingCaps = index.get(sf.getValue());
                if (existingCaps == null) break block5;
                matches.addAll(existingCaps);
                matches.retainAll(caps);
                break block5;
            }
            for (Capability cap : caps) {
                Object lhs = cap.getAttributes().get(sf.getName());
                if (lhs == null || !CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation())) continue;
                matches.add(cap);
            }
        }
        return matches;
    }

    public static boolean matches(Capability capability, Requirement requirement) {
        return Objects.equals(capability.getNamespace(), requirement.getNamespace()) && CapabilitySet.matches(capability, RequirementImpl.getFilter(requirement));
    }

    public static boolean matches(Capability cap, SimpleFilter sf) {
        return CapabilitySet.matchesInternal(cap, sf) && CapabilitySet.matchMandatory(cap, sf);
    }

    private static boolean matchesInternal(Capability cap, SimpleFilter sf) {
        boolean matched = true;
        if (sf.getOperation() == 0) {
            matched = true;
        } else if (sf.getOperation() == 1) {
            List sfs = (List)sf.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 2) {
            matched = false;
            List sfs = (List)sf.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 3) {
            List sfs = (List)sf.getValue();
            for (SimpleFilter sf1 : sfs) {
                matched = !CapabilitySet.matchesInternal(cap, sf1);
            }
        } else {
            matched = false;
            Object lhs = cap.getAttributes().get(sf.getName());
            if (lhs != null) {
                matched = CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation());
            }
        }
        return matched;
    }

    private static Set<Capability> matchMandatory(Set<Capability> caps, SimpleFilter sf) {
        Iterator<Capability> it = caps.iterator();
        while (it.hasNext()) {
            Capability cap = it.next();
            if (CapabilitySet.matchMandatory(cap, sf)) continue;
            it.remove();
        }
        return caps;
    }

    private static boolean matchMandatory(Capability cap, SimpleFilter sf) {
        block3: {
            block2: {
                if (!(cap instanceof CapabilityImpl)) break block2;
                for (Map.Entry entry : cap.getAttributes().entrySet()) {
                    if (!((CapabilityImpl)cap).isAttributeMandatory((String)entry.getKey()) || CapabilitySet.matchMandatoryAttribute((String)entry.getKey(), sf)) continue;
                    return false;
                }
                break block3;
            }
            String value = (String)cap.getDirectives().get("mandatory");
            if (value == null) break block3;
            List<String> names = ResourceBuilder.parseDelimitedString(value, ",");
            for (Map.Entry entry : cap.getAttributes().entrySet()) {
                if (!names.contains(entry.getKey()) || CapabilitySet.matchMandatoryAttribute((String)entry.getKey(), sf)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchMandatoryAttribute(String attrName, SimpleFilter sf) {
        if (sf.getName() != null && sf.getName().equals(attrName)) {
            return true;
        }
        if (sf.getOperation() == 1) {
            List list = (List)sf.getValue();
            for (Object aList : list) {
                SimpleFilter sf2 = (SimpleFilter)aList;
                if (sf2.getName() == null || !sf2.getName().equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (lhs == null) {
            return false;
        }
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) == 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 6: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) >= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 5: {
                    try {
                        return ((Comparable)((Object)lhs)).compareTo(rhs) <= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 9: {
                    return CapabilitySet.compareApproximate(lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)((Object)lhs));
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs.getClass().isArray()) {
            lhs = CapabilitySet.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            for (Object o : (Collection)lhs) {
                if (!CapabilitySet.compare(o, rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7) {
            return false;
        }
        try {
            return ((Object)lhs).equals(CapabilitySet.coerceType(lhs, (String)rhsUnknown));
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return CapabilitySet.removeWhitespace((String)lhs).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        Object rhs;
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        try {
            if (lhs instanceof Version) {
                rhs = VersionTable.getVersion(rhsString, false);
            } else if (lhs instanceof Character) {
                rhs = Character.valueOf(rhsString.charAt(0));
            } else {
                if (lhs instanceof Number || lhs instanceof Boolean) {
                    rhsString = rhsString.trim();
                }
                Constructor<?> ctor = lhs.getClass().getConstructor(STRING_CLASS);
                ctor.setAccessible(true);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate class " + lhs.getClass().getName() + " from string constructor with argument '" + rhsString + "' because " + ex);
        }
        return rhs;
    }

    private static List<Object> convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

