/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.json.FeatureJSONWriter;

public class ArchiveWriter {
    public static final String VERSION_HEADER = "Feature-Archive-Version";
    public static final String CONTENTS_HEADER = "Feature-Archive-Contents";
    public static final int ARCHIVE_VERSION = 1;

    public static JarOutputStream write(OutputStream out, Manifest baseManifest, ArtifactProvider provider, Feature ... features) throws IOException {
        Manifest manifest = baseManifest == null ? new Manifest() : new Manifest(baseManifest);
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue(VERSION_HEADER, String.valueOf(1));
        manifest.getMainAttributes().putValue(CONTENTS_HEADER, String.join((CharSequence)",", Arrays.asList(features).stream().map(feature -> feature.getId().toMvnId()).collect(Collectors.toList())));
        JarOutputStream jos = new JarOutputStream(out, manifest);
        jos.setLevel(9);
        for (Feature feature2 : features) {
            JarEntry entry = new JarEntry(feature2.getId().toMvnPath());
            jos.putNextEntry(entry);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
            FeatureJSONWriter.write(writer, feature2);
            ((Writer)writer).flush();
            jos.closeEntry();
        }
        jos.setLevel(0);
        byte[] buffer = new byte[0x10000000];
        HashSet<ArtifactId> artifacts = new HashSet<ArtifactId>();
        for (Feature feature3 : features) {
            for (Artifact a : feature3.getBundles()) {
                ArchiveWriter.writeArtifact(artifacts, provider, a, jos, buffer);
            }
            for (Extension e : feature3.getExtensions()) {
                if (e.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact a : e.getArtifacts()) {
                    ArchiveWriter.writeArtifact(artifacts, provider, a, jos, buffer);
                }
            }
        }
        return jos;
    }

    private static void writeArtifact(Set<ArtifactId> artifacts, ArtifactProvider provider, Artifact artifact, JarOutputStream jos, byte[] buffer) throws IOException {
        if (artifacts.add(artifact.getId())) {
            JarEntry artifactEntry = new JarEntry(artifact.getId().toMvnPath());
            jos.putNextEntry(artifactEntry);
            URL url = provider.provide(artifact.getId());
            if (url == null) {
                throw new IOException("Unable to find artifact " + artifact.getId().toMvnId());
            }
            try (InputStream is = url.openStream();){
                int l = 0;
                while ((l = is.read(buffer)) > 0) {
                    jos.write(buffer, 0, l);
                }
            }
            jos.closeEntry();
        }
    }
}

