/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.serializer.ConfigurationSerializerFactory;
import org.apache.sling.installer.factories.configuration.impl.Activator;
import org.apache.sling.installer.factories.configuration.impl.ConfigTaskCreator;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.apache.sling.installer.factories.configuration.impl.SortedDictionary;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling OSGi Installer Configuration Serializer Web Console Plugin", "felix.webconsole.label=osgi-installer-config-printer", "felix.webconsole.title=OSGi Installer Configuration Printer", "felix.webconsole.category=OSGi"})
public class ConfigurationSerializerWebConsolePlugin
extends GenericServlet {
    public static final String LABEL = "osgi-installer-config-printer";
    private static final String RES_LOC = "osgi-installer-config-printer/res/ui/";
    private static final String PARAMETER_PID = "pid";
    private static final String PARAMETER_FORMAT = "format";
    private static final String PARAMETER_HIDE_REDUNDANT_PROPERTIES = "hideRedundantProperties";
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSerializerWebConsolePlugin.class);
    @Reference
    ConfigurationAdmin configurationAdmin;
    @Reference
    private InfoProvider infoProvider;
    @Reference
    private ServiceComponentRuntime scr;

    public void service(ServletRequest request, ServletResponse response) throws IOException {
        String pid = request.getParameter(PARAMETER_PID);
        Configuration configuration = pid != null && !pid.trim().isEmpty() ? this.configurationAdmin.getConfiguration(pid, null) : null;
        String format = request.getParameter(PARAMETER_FORMAT);
        ConfigurationSerializerFactory.Format serializationFormat = ConfigurationSerializerFactory.Format.JSON;
        if (format != null && !format.trim().isEmpty()) {
            try {
                serializationFormat = ConfigurationSerializerFactory.Format.valueOf((String)format);
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.warn("Illegal parameter 'format' given, falling back to default '{}'", (Object)serializationFormat, (Object)e);
            }
        }
        boolean hideRedundantProperties = format == null ? true : Boolean.parseBoolean(request.getParameter(PARAMETER_HIDE_REDUNDANT_PROPERTIES));
        this.dumpConfiguration(configuration, serializationFormat, hideRedundantProperties, response.getWriter());
    }

    private void dumpConfiguration(Configuration configuration, ConfigurationSerializerFactory.Format serializationFormat, boolean hideRedundantProperties, PrintWriter pw) {
        String pidReferencedFromComponentDescription;
        HashMap<String, Set<ComponentDescriptionDTO>> allComponentDescriptions = new HashMap<String, Set<ComponentDescriptionDTO>>();
        String pid = configuration != null ? configuration.getPid() : "";
        this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().forEach(dto -> {
            for (String configPid : dto.configurationPid) {
                allComponentDescriptions.computeIfAbsent(configPid, k -> new HashSet()).add(dto);
            }
        });
        pw.println("<script type=\"text/javascript\" src=\"osgi-installer-config-printer/res/ui/clipboard.js\"></script>");
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.titleHtml(pw, "OSGi Installer Configuration Printer", "To emit the configuration properties just enter the configuration PID, select a <a href='https://sling.apache.org/documentation/bundles/configuration-installer-factory.html'>serialization format</a> and click 'Print'");
        this.tr(pw);
        this.tdLabel(pw, "PID");
        this.tdContent(pw);
        pw.printf("<input type='text' name='%s' ' value='%s' class='input' size='120' minlength='3'>", PARAMETER_PID, this.escapeXml(pid));
        pw.println();
        pw.println("<p>For factory configurations use the factory PID followed by a tilde and the configuration name, e.g. 'my.factory.pid~myname'</p>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Hide Properties");
        this.tdContent(pw);
        pw.append("<input type='checkbox' name='");
        pw.append(PARAMETER_HIDE_REDUNDANT_PROPERTIES);
        pw.append("'");
        if (hideRedundantProperties) {
            pw.print(" checked");
        }
        pw.append(" id='");
        pw.append(PARAMETER_HIDE_REDUNDANT_PROPERTIES);
        pw.append("' class='input' value='true'>").println();
        pw.append("<label for='");
        pw.append(PARAMETER_HIDE_REDUNDANT_PROPERTIES);
        pw.append("'>");
        pw.append("Redundant Properties (");
        StringBuilder sb = new StringBuilder();
        Dictionary<String, Object> mergedProperties = ConfigTaskCreator.getDefaultProperties(this.infoProvider, pid);
        if (mergedProperties == null) {
            mergedProperties = new Hashtable<String, Object>();
        }
        if (mergedProperties.size() > 0) {
            sb.append("from <a href=\"https://sling.apache.org/documentation/bundles/configuration-installer-factory.html#merging-of-configurations\">Merge Schemes</a> ");
            sb.append("\"").append(String.join((CharSequence)", ", Activator.MERGE_SCHEMES)).append("\"");
        }
        if (configuration != null) {
            pidReferencedFromComponentDescription = configuration.getFactoryPid() != null ? configuration.getFactoryPid() : configuration.getPid();
            Set componentDescriptions = (Set)allComponentDescriptions.get(pidReferencedFromComponentDescription);
            if (componentDescriptions != null) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append("from component description(s) of ");
                sb.append(componentDescriptions.stream().map(componentDescription -> String.format("<a href=\"components/%d/%s/%s\">component \"%s\" (bundle %d)</a>", componentDescription.bundle.id, componentDescription.name, componentDescription.configurationPid[0], componentDescription.name, componentDescription.bundle.id)).collect(Collectors.joining(", ")));
            }
        } else {
            pidReferencedFromComponentDescription = "";
        }
        if (sb.length() == 0) {
            sb.append("no fallback sources found");
        }
        pw.append(sb.toString()).append(")</label>").println();
        pw.println("<p>Enabling it hides those properties which have the same name and value as any of their fallback sources.</p>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Serialization Format");
        this.tdContent(pw);
        pw.print("<select name='");
        pw.print(PARAMETER_FORMAT);
        pw.println("'>");
        this.option(pw, "JSON", "OSGi Configurator JSON", serializationFormat.name());
        this.option(pw, "CONFIG", "Apache Felix Config", serializationFormat.name());
        this.option(pw, "PROPERTIES", "Java Properties", serializationFormat.name());
        this.option(pw, "PROPERTIES_XML", "Java Properties (XML)", serializationFormat.name());
        pw.println("</select>");
        pw.println("&nbsp;&nbsp;<input type='submit' value='Print' class='submit'>");
        this.closeTd(pw);
        this.closeTr(pw);
        if (configuration != null) {
            this.tr(pw);
            this.tdLabel(pw, "Serialized Configuration Properties");
            this.tdContent(pw);
            Dictionary<String, Object> properties = configuration.getProperties();
            if (properties == null) {
                pw.print("<p class='ui-state-error-text'>");
                pw.print("No configuration properties for pid '" + this.escapeXml(pid) + "' found!");
                pw.println("</p>");
            } else {
                properties = ConfigUtil.cleanConfiguration(properties);
                if (hideRedundantProperties) {
                    this.removeComponentDefaultProperties(allComponentDescriptions, pidReferencedFromComponentDescription, properties, mergedProperties);
                    ConfigUtil.removeRedundantProperties(properties, mergedProperties);
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ConfigurationSerializerFactory.create((ConfigurationSerializerFactory.Format)serializationFormat).serialize(new SortedDictionary<String, Object>(properties), (OutputStream)baos);
                    pw.println("<textarea rows=\"20\" cols=\"120\" id=\"output\" readonly>");
                    pw.print(new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    pw.println("</textarea>");
                    pw.println("<button type='button' id='copy'>Copy to Clipboard</a>");
                }
                catch (Exception e) {
                    pw.print("<p class='ui-state-error-text'>");
                    pw.print("Error serializing pid '" + this.escapeXml(pid) + "': " + e.getMessage());
                    pw.println("</p>");
                    this.LOGGER.warn("Error serializing pid '{}'", (Object)pid, (Object)e);
                }
            }
            this.closeTd(pw);
            this.closeTr(pw);
        }
        pw.println("</table>");
        pw.print("</form>");
    }

    private void tdContent(PrintWriter pw) {
        pw.print("<td class='content' colspan='2'>");
    }

    private void closeTd(PrintWriter pw) {
        pw.print("</td>");
    }

    private void closeTr(PrintWriter pw) {
        pw.println("</tr>");
    }

    private void tdLabel(PrintWriter pw, String label) {
        pw.print("<td class='content'>");
        pw.print(label);
        pw.println("</td>");
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr class='content'>");
    }

    private void option(PrintWriter pw, String value, String label, String selectedValue) {
        pw.print("<option value='");
        pw.print(value);
        pw.print("'");
        if (value.equals(selectedValue)) {
            pw.print(" selected");
        }
        pw.print(">");
        pw.print(label);
        pw.println("</option>");
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        this.tr(pw);
        pw.print("<th colspan='3' class='content container'>");
        pw.print(this.escapeXml(title));
        pw.println("</th>");
        this.closeTr(pw);
        if (description != null) {
            this.tr(pw);
            pw.print("<td colspan='3' class='content'>");
            pw.print(description);
            pw.println("</th>");
            this.closeTr(pw);
        }
    }

    protected String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void removeComponentDefaultProperties(Map<String, Set<ComponentDescriptionDTO>> allComponentDescriptions, String pidReferencedFromComponentDescription, Dictionary<String, Object> properties, Dictionary<String, Object> mergedProperties) {
        Set<ComponentDescriptionDTO> componentDescriptions = allComponentDescriptions.get(pidReferencedFromComponentDescription);
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            Object defaultValue;
            Set defaultValues;
            String key = e.nextElement();
            Object newValue = properties.get(key);
            if (componentDescriptions == null || (defaultValues = componentDescriptions.stream().map(dto -> dto.properties.get(key)).filter(Objects::nonNull).collect(Collectors.toSet())).size() != 1 || !ConfigUtil.isSameValue(newValue, defaultValue = defaultValues.iterator().next()) || mergedProperties.get(key) != null) continue;
            properties.remove(key);
        }
    }

    String getRelativeResourcePrefix() {
        return RES_LOC;
    }

    private URL getResource(String path) {
        if (path.startsWith("/" + this.getRelativeResourcePrefix())) {
            int index = path.indexOf(47, 1);
            if (index <= 0) {
                throw new IllegalStateException("The relativeResourcePrefix must contain at least one '/'");
            }
            return ((Object)((Object)this)).getClass().getResource(path.substring(index));
        }
        return null;
    }
}

