/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;

class JcrXmlValueConverter {
    private JcrXmlValueConverter() {
    }

    public static Object parseValue(String name, String value) {
        if (value == null) {
            return null;
        }
        DocViewProperty prop = DocViewProperty.parse((String)name, (String)value);
        if (prop.isMulti) {
            Class<?> arrayType = JcrXmlValueConverter.getType(prop.type);
            if (arrayType == null) {
                return null;
            }
            Object result = Array.newInstance(arrayType, prop.values.length);
            for (int i = 0; i < prop.values.length; ++i) {
                Array.set(result, i, JcrXmlValueConverter.convertValue(prop.values[i], prop.type, true));
            }
            return result;
        }
        return JcrXmlValueConverter.convertValue(prop.values[0], prop.type, false);
    }

    private static Object convertValue(String value, int type, boolean inArray) {
        switch (type) {
            case 0: 
            case 1: 
            case 7: 
            case 8: {
                return value;
            }
            case 6: {
                return Boolean.valueOf(value);
            }
            case 3: {
                return Long.valueOf(value);
            }
            case 4: {
                return Double.valueOf(value);
            }
            case 12: {
                return new BigDecimal(value);
            }
            case 5: {
                return ISO8601.parse((String)value);
            }
            case 9: 
            case 10: {
                return UUID.fromString(value);
            }
            case 11: {
                try {
                    return new URI(value);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Unexpected URI syntax: " + value);
                }
            }
            case 2: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + PropertyType.nameFromValue((int)type));
    }

    private static Class<?> getType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 7: 
            case 8: {
                return String.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return Double.class;
            }
            case 12: {
                return BigDecimal.class;
            }
            case 5: {
                return Calendar.class;
            }
            case 9: 
            case 10: {
                return UUID.class;
            }
            case 11: {
                return URI.class;
            }
            case 2: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + PropertyType.nameFromValue((int)type));
    }
}

