/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.servlet.Servlet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.sling.jcr.jackrabbit.accessmanager.DeletePrincipalAces;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrincipalAceHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeleteAcesServlet;
import org.apache.sling.servlets.post.JakartaPostResponseCreator;
import org.apache.sling.servlets.post.Modification;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, DeletePrincipalAces.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=deletePAce", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="PostResponseCreator", bind="bindPostResponseCreator", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=JakartaPostResponseCreator.class)})
public class DeletePrincipalAcesServlet
extends DeleteAcesServlet
implements DeletePrincipalAces {
    private static final long serialVersionUID = 3784866802938282971L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected boolean allowNonExistingPaths() {
        return true;
    }

    @Override
    public void deletePrincipalAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        this.deleteAces(jcrSession, resourcePath, principalNamesToDelete, null);
    }

    @Override
    protected void deleteAces(Session jcrSession, String resourcePath, String[] principalNamesToDelete, List<Modification> changes) throws RepositoryException {
        @NotNull Set<Principal> found = this.validateArgs(jcrSession, resourcePath, principalNamesToDelete);
        try {
            JackrabbitAccessControlManager jacm = (JackrabbitAccessControlManager)jcrSession.getAccessControlManager();
            HashSet<Principal> removedPrincipalSet = new HashSet<Principal>();
            for (Principal principal : found) {
                PrincipalAccessControlList updatedAcl = this.getAccessControlListOrNull(jacm, principal);
                if (updatedAcl == null) {
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                    continue;
                }
                AccessControlEntry[] accessControlEntries = (AccessControlEntry[])Stream.of(updatedAcl.getAccessControlEntries()).filter(entry -> entry instanceof PrincipalAccessControlList.Entry && PrincipalAceHelper.matchesResourcePath(resourcePath, entry)).toArray(AccessControlEntry[]::new);
                ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
                for (AccessControlEntry ace : accessControlEntries) {
                    if (!found.contains(ace.getPrincipal())) continue;
                    oldAces.add(ace);
                }
                if (!oldAces.isEmpty()) {
                    for (AccessControlEntry ace : oldAces) {
                        updatedAcl.removeAccessControlEntry(ace);
                        removedPrincipalSet.add(ace.getPrincipal());
                    }
                }
                if (removedPrincipalSet.contains(principal)) {
                    if (changes != null) {
                        changes.add(Modification.onDeleted((String)principal.getName()));
                    }
                } else {
                    this.log.warn("No AccessControlEntry was found to be deleted for principal: {}", (Object)principal.getName());
                }
                jacm.setPolicy(updatedAcl.getPath(), (AccessControlPolicy)updatedAcl);
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to delete access control.", (Throwable)re);
        }
    }

    protected PrincipalAccessControlList getAccessControlListOrNull(JackrabbitAccessControlManager jacm, Principal principal) throws RepositoryException {
        JackrabbitAccessControlPolicy[] policies;
        PrincipalAccessControlList acl = null;
        for (JackrabbitAccessControlPolicy policy : policies = jacm.getPolicies(principal)) {
            PrincipalAccessControlList pacList;
            if (!(policy instanceof PrincipalAccessControlList)) continue;
            acl = pacList = (PrincipalAccessControlList)policy;
        }
        return acl;
    }
}

