/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Map;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.ModelProcessor;
import org.apache.sling.provisioning.model.ModelResolveUtility;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;

class EffectiveModelProcessor
extends ModelProcessor {
    private final ModelUtility.ResolverOptions options;

    public EffectiveModelProcessor(ModelUtility.ResolverOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Resolver options is null");
        }
        this.options = options;
    }

    @Override
    protected Artifact processArtifact(Artifact artifact, Feature newFeature, RunMode newRunMode) {
        String groupId = ModelResolveUtility.replace(newFeature, artifact.getGroupId(), this.options.getVariableResolver());
        String artifactId = ModelResolveUtility.replace(newFeature, artifact.getArtifactId(), this.options.getVariableResolver());
        String version = ModelResolveUtility.replace(newFeature, artifact.getVersion(), this.options.getVariableResolver());
        String classifier = ModelResolveUtility.replace(newFeature, artifact.getClassifier(), this.options.getVariableResolver());
        String type = ModelResolveUtility.replace(newFeature, artifact.getType(), this.options.getVariableResolver());
        String resolvedVersion = ModelResolveUtility.resolveArtifactVersion(groupId, artifactId, version, classifier, type, this.options.getArtifactVersionResolver());
        return new Artifact(groupId, artifactId, resolvedVersion, classifier, type, artifact.getMetadata());
    }

    @Override
    protected Configuration processConfiguration(Configuration config, Feature newFeature, RunMode newRunMode) {
        Configuration newConfig = new Configuration(config.getPid(), config.getFactoryPid());
        ModelResolveUtility.getProcessedConfiguration(newFeature, newConfig, config, true, this.options.getVariableResolver());
        return newConfig;
    }

    @Override
    protected KeyValueMap<String> processSettings(KeyValueMap<String> settings, final Feature newFeature, RunMode newRunMode) {
        KeyValueMap<String> newSettings = new KeyValueMap<String>();
        for (Map.Entry<String, String> entry : settings) {
            newSettings.put(entry.getKey(), ModelResolveUtility.replace(newFeature, entry.getValue(), new ModelUtility.VariableResolver(){

                @Override
                public String resolve(Feature feature, String name) {
                    if ("sling.home".equals(name)) {
                        return "${sling.home}";
                    }
                    if (EffectiveModelProcessor.this.options.getVariableResolver() != null) {
                        return EffectiveModelProcessor.this.options.getVariableResolver().resolve(newFeature, name);
                    }
                    return newFeature.getVariables().get(name);
                }
            }));
        }
        return newSettings;
    }
}

