/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Enumeration;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;

class ModelProcessor {
    ModelProcessor() {
    }

    public final Model process(Model model) {
        Model result = new Model();
        result.setLocation(model.getLocation());
        for (Feature feature : model.getFeatures()) {
            Feature newFeature = result.getOrCreateFeature(feature.getName());
            newFeature.setType(feature.getType());
            newFeature.setComment(feature.getComment());
            newFeature.setLocation(feature.getLocation());
            newFeature.setVersion(feature.getVersion());
            newFeature.getAdditionalSections().addAll(feature.getAdditionalSections());
            newFeature.getVariables().setComment(feature.getVariables().getComment());
            newFeature.getVariables().setLocation(feature.getVariables().getLocation());
            newFeature.getVariables().putAll(this.processVariables(feature.getVariables(), feature));
            for (RunMode runMode : feature.getRunModes()) {
                RunMode newRunMode = newFeature.getOrCreateRunMode(runMode.getNames());
                newRunMode.setLocation(runMode.getLocation());
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    ArtifactGroup newGroup = newRunMode.getOrCreateArtifactGroup(group.getStartLevel());
                    newGroup.setComment(group.getComment());
                    newGroup.setLocation(group.getLocation());
                    for (Artifact artifact : group) {
                        Artifact newArtifact = this.processArtifact(artifact, newFeature, newRunMode);
                        newArtifact.setComment(artifact.getComment());
                        newArtifact.setLocation(artifact.getLocation());
                        newGroup.add(newArtifact);
                    }
                }
                newRunMode.getConfigurations().setComment(runMode.getConfigurations().getComment());
                newRunMode.getConfigurations().setLocation(runMode.getConfigurations().getLocation());
                for (Configuration config : runMode.getConfigurations()) {
                    Configuration processedConfig = this.processConfiguration(config, newFeature, newRunMode);
                    Configuration newConfig = newRunMode.getOrCreateConfiguration(processedConfig.getPid(), processedConfig.getFactoryPid());
                    newConfig.setLocation(config.getLocation());
                    newConfig.setComment(config.getComment());
                    Enumeration<String> i = processedConfig.getProperties().keys();
                    while (i.hasMoreElements()) {
                        String key = i.nextElement();
                        newConfig.getProperties().put(key, processedConfig.getProperties().get(key));
                    }
                }
                newRunMode.getSettings().setComment(runMode.getSettings().getComment());
                newRunMode.getSettings().setLocation(runMode.getSettings().getLocation());
                newRunMode.getSettings().putAll(this.processSettings(runMode.getSettings(), newFeature, newRunMode));
            }
        }
        return result;
    }

    protected KeyValueMap<String> processVariables(KeyValueMap<String> variables, Feature newFeature) {
        return variables;
    }

    protected Artifact processArtifact(Artifact artifact, Feature newFeature, RunMode newRunMode) {
        return artifact;
    }

    protected Configuration processConfiguration(Configuration config, Feature newFeature, RunMode newRunMode) {
        return config;
    }

    protected KeyValueMap<String> processSettings(KeyValueMap<String> settings, Feature newFeature, RunMode newRunMode) {
        return settings;
    }
}

