/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.filevault.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.Configurations;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericJcrDataValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepoInitValidator
implements DocumentViewXmlValidator,
GenericJcrDataValidator {
    private static final String SLING_OSGI_CONFIG_NODETYPE = "sling:OsgiConfig";
    private static final String OSGI_CONFIG_NAME = "org\\.apache\\.sling\\.jcr\\.repoinit\\.RepositoryInitializer([~-]).*";
    private static final Pattern OSGI_CONFIG_NODE_NAME_PATTERN = Pattern.compile("org\\.apache\\.sling\\.jcr\\.repoinit\\.RepositoryInitializer([~-]).*");
    private static final Pattern OSGI_CONFIG_FILE_NAME_PATTERN = Pattern.compile("org\\.apache\\.sling\\.jcr\\.repoinit\\.RepositoryInitializer([~-]).*\\.(config|cfg\\.json|cfg)");
    private final RepoInitParserService parser = new RepoInitParserService();

    @Nullable
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        Optional scriptsProperty;
        if (SLING_OSGI_CONFIG_NODETYPE.equals(node.getPrimaryType().orElse("")) && OSGI_CONFIG_NODE_NAME_PATTERN.matcher(Text.getName((String)nodeContext.getNodePath())).matches() && (scriptsProperty = node.getProperty(NameFactoryImpl.getInstance().create("", "scripts"))).isPresent()) {
            try {
                return this.validateStatements(((DocViewProperty2)scriptsProperty.get()).getStringValues(), nodeContext.getFilePath().toString());
            }
            catch (IOException e) {
                return Collections.singleton(new ValidationMessage(ValidationMessageSeverity.ERROR, "IOException while parsing " + nodeContext.getFilePath() + " : " + e.getMessage(), (Throwable)e));
            }
        }
        return null;
    }

    @Nullable
    public Collection<ValidationMessage> validateJcrData(@NotNull InputStream input, @NotNull Path filePath, @NotNull Path basePath, @NotNull Map<String, Integer> nodePathsAndLineNumbers) throws IOException {
        Map<String, Object> config = this.deserializeOsgiConfiguration(this.getType(filePath.getFileName().toString()), input);
        return this.validateConfig(config, filePath.toString());
    }

    public boolean shouldValidateJcrData(@NotNull Path filePath, @NotNull Path basePath) {
        return this.isOsgiConfig(filePath);
    }

    private OsgiConfigurationSerialization getType(String fileName) {
        if (fileName.endsWith(".cfg.json")) {
            return OsgiConfigurationSerialization.CFG_JSON;
        }
        if (fileName.endsWith(".config")) {
            return OsgiConfigurationSerialization.CONFIG;
        }
        if (fileName.endsWith(".cfg")) {
            return OsgiConfigurationSerialization.CFG;
        }
        throw new IllegalArgumentException("Given file name " + fileName + " does not represent a known OSGi configuration serialization");
    }

    private boolean isOsgiConfig(@NotNull Path filePath) {
        String fileName = filePath.getFileName().toString();
        return OSGI_CONFIG_FILE_NAME_PATTERN.matcher(fileName).matches();
    }

    Map<String, Object> deserializeOsgiConfiguration(@NotNull OsgiConfigurationSerialization serializationType, @NotNull InputStream input) throws IOException {
        switch (serializationType) {
            case CONFIG: {
                return RepoInitValidator.convertToMap(ConfigurationHandler.read((InputStream)input));
            }
            case CFG: {
                Properties properties = new Properties();
                properties.load(input);
                return RepoInitValidator.convertToMap(properties);
            }
            case CFG_JSON: {
                InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
                ConfigurationReader configReader = Configurations.buildReader().build((Reader)reader);
                return RepoInitValidator.convertToMap(configReader.readConfiguration());
            }
        }
        return null;
    }

    private Collection<ValidationMessage> validateConfig(Map<String, Object> config, String source) throws IOException {
        Object scripts = config.get("scripts");
        if (scripts == null) {
            return null;
        }
        if (scripts instanceof String[]) {
            return this.validateStatements(Arrays.asList((String[])scripts), source);
        }
        if (scripts instanceof String) {
            return this.validateStatements((String)scripts, source);
        }
        return Collections.singletonList(new ValidationMessage(ValidationMessageSeverity.ERROR, "OSGi config property 'scripts' must be of type String or String[]"));
    }

    private Collection<ValidationMessage> validateStatements(Collection<String> scripts, String source) throws IOException {
        ArrayList<ValidationMessage> validationMsgs = new ArrayList<ValidationMessage>();
        validationMsgs.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Validating repoinit statements from " + source));
        for (String statements : scripts) {
            this.validateStatements(statements).ifPresent(validationMsgs::add);
        }
        return validationMsgs;
    }

    private Collection<ValidationMessage> validateStatements(String statements, String source) throws IOException {
        ArrayList<ValidationMessage> validationMsgs = new ArrayList<ValidationMessage>();
        validationMsgs.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Validating repoinit statements from " + source));
        this.validateStatements(statements).ifPresent(validationMsgs::add);
        return validationMsgs;
    }

    private Optional<ValidationMessage> validateStatements(String statements) throws IOException {
        try (StringReader reader = new StringReader(statements);){
            this.parser.parse((Reader)reader);
        }
        catch (RepoInitParsingException e) {
            return Optional.of(new ValidationMessage(ValidationMessageSeverity.ERROR, "Invalid repoinit statement(s) detected: " + e.getMessage(), (Throwable)e));
        }
        return Optional.empty();
    }

    static Map<String, Object> convertToMap(Dictionary<String, ?> dictionary) {
        ArrayList<String> keys = Collections.list(dictionary.keys());
        return keys.stream().collect(Collectors.toMap(Function.identity(), dictionary::get));
    }

    static Map<String, Object> convertToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    static enum OsgiConfigurationSerialization {
        CFG,
        CFG_JSON,
        CONFIG;

    }
}

