/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.sling.rewriter.Generator;
import org.apache.sling.rewriter.PipelineConfiguration;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.apache.sling.rewriter.impl.ProcessingComponentConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PipelineImpl
implements Processor {
    private final Logger LOGGER = LoggerFactory.getLogger(PipelineImpl.class);
    private static final Transformer[] EMPTY_TRANSFORMERS = new Transformer[0];
    private Generator generator;
    private Transformer[] transformers;
    private Serializer serializer;
    private ContentHandler firstContentHandler;
    private final FactoryCache factoryCache;

    public PipelineImpl(FactoryCache factoryCache) {
        this.factoryCache = factoryCache;
    }

    @Override
    public void init(ProcessingContext processingContext, ProcessorConfiguration c) throws IOException {
        this.LOGGER.debug("Setting up pipeline...");
        PipelineConfiguration config = (PipelineConfiguration)c;
        ProcessingComponentConfiguration[] transformerConfigs = config.getTransformerConfigurations();
        Transformer[][] rewriters = this.factoryCache.getGlobalTransformers(processingContext);
        ProcessingComponentConfiguration generatorConfig = config.getGeneratorConfiguration();
        this.generator = this.getPipelineComponent(Generator.class, generatorConfig.getType(), false);
        this.LOGGER.debug("Using generator type {}: {}.", (Object)generatorConfig.getType(), (Object)this.generator);
        this.generator.init(processingContext, generatorConfig);
        int transformerCount = (transformerConfigs == null ? 0 : transformerConfigs.length) + rewriters[0].length + rewriters[1].length;
        int index = 0;
        if (transformerCount > 0) {
            int i;
            this.transformers = new Transformer[transformerCount];
            for (i = 0; i < rewriters[0].length; ++i) {
                if (rewriters[0][i] == null) continue;
                this.transformers[index] = rewriters[0][i];
                this.LOGGER.debug("Using pre transformer: {}.", (Object)this.transformers[index]);
                this.transformers[index].init(processingContext, ProcessingComponentConfigurationImpl.EMPTY);
                ++index;
            }
            if (transformerConfigs != null) {
                for (i = 0; i < transformerConfigs.length; ++i) {
                    this.transformers[index] = this.getPipelineComponent(Transformer.class, transformerConfigs[i].getType(), (Boolean)transformerConfigs[i].getConfiguration().get("component-optional", (Object)false));
                    if (this.transformers[index] != null) {
                        this.LOGGER.debug("Using transformer type {}: {}.", (Object)transformerConfigs[i].getType(), (Object)this.transformers[index]);
                        this.transformers[index].init(processingContext, transformerConfigs[i]);
                        ++index;
                        continue;
                    }
                    this.LOGGER.debug("Skipping missing optional transformer of type {}", (Object)transformerConfigs[i].getType());
                }
            }
            for (i = 0; i < rewriters[1].length; ++i) {
                if (rewriters[1][i] == null) continue;
                this.transformers[index] = rewriters[1][i];
                this.LOGGER.debug("Using post transformer: {}.", (Object)this.transformers[index]);
                this.transformers[index].init(processingContext, ProcessingComponentConfigurationImpl.EMPTY);
                ++index;
            }
        } else {
            this.transformers = EMPTY_TRANSFORMERS;
        }
        ProcessingComponentConfiguration serializerConfig = config.getSerializerConfiguration();
        this.serializer = this.getPipelineComponent(Serializer.class, serializerConfig.getType(), false);
        this.LOGGER.debug("Using serializer type {}: {}.", (Object)serializerConfig.getType(), (Object)this.serializer);
        this.serializer.init(processingContext, serializerConfig);
        ContentHandler pipelineComponent = this.serializer;
        for (int i = index; i > 0; --i) {
            this.transformers[i - 1].setContentHandler(pipelineComponent);
            pipelineComponent = this.transformers[i - 1];
        }
        this.firstContentHandler = pipelineComponent;
        this.generator.setContentHandler(this.firstContentHandler);
        this.LOGGER.debug("Finished pipeline setup.");
    }

    private <ComponentType> ComponentType getPipelineComponent(Class<ComponentType> typeClass, String type, boolean optional) throws IOException {
        Object component = typeClass == Generator.class ? this.factoryCache.getGenerator(type) : (typeClass == Transformer.class ? this.factoryCache.getTransformer(type) : (typeClass == Serializer.class ? this.factoryCache.getSerializer(type) : null));
        if (component == null && !optional) {
            throw new IOException("Unable to get component of class '" + typeClass + "' with type '" + type + "'.");
        }
        return (ComponentType)component;
    }

    @Override
    public PrintWriter getWriter() {
        return this.generator.getWriter();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.firstContentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(boolean errorOccured) throws IOException {
        block10: {
            try {
                if (errorOccured) break block10;
                try {
                    this.generator.finished();
                }
                catch (SAXException se) {
                    if (se.getCause() != null && se.getCause() instanceof IOException) {
                        throw (IOException)se.getCause();
                    }
                    IOException ioe = new IOException("Pipeline exception: " + se.getMessage());
                    ioe.initCause(se);
                    throw ioe;
                }
            }
            finally {
                if (this.generator != null) {
                    this.generator.dispose();
                }
                if (this.transformers != null) {
                    for (Transformer transformer : this.transformers) {
                        if (transformer == null) continue;
                        transformer.dispose();
                    }
                }
                if (this.serializer != null) {
                    this.serializer.dispose();
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pipeline Processor (");
        sb.append(super.toString());
        sb.append(") : ");
        sb.append("generator: ");
        sb.append(this.generator != null ? this.generator : "-");
        sb.append(", transformers: [");
        if (this.transformers != null && this.transformers.length > 0) {
            boolean first = true;
            for (Transformer t : this.transformers) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(t);
            }
            sb.append("]");
        } else {
            sb.append("-");
        }
        sb.append(", serializer: ");
        sb.append(this.serializer != null ? this.serializer : "-");
        return sb.toString();
    }
}

