/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.core.impl.ContextBvpCollector;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={BindingsValuesProvidersByContext.class}, property={"service.vendor=The Apache Software Foundation"})
public class BindingsValuesProvidersByContextImpl
implements BindingsValuesProvidersByContext {
    private final Map<String, ContextBvpCollector> customizers = new HashMap<String, ContextBvpCollector>();
    public static final String[] DEFAULT_CONTEXT_ARRAY = new String[]{"request"};
    private static final String TOPIC_CREATED = "org/apache/sling/scripting/core/BindingsValuesProvider/CREATED";
    private static final String TOPIC_MODIFIED = "org/apache/sling/scripting/core/BindingsValuesProvider/MODIFIED";
    private static final String TOPIC_REMOVED = "org/apache/sling/scripting/core/BindingsValuesProvider/REMOVED";
    private ServiceTracker<BindingsValuesProvider, Object> bvpTracker;
    private ServiceTracker<Map, Object> mapsTracker;
    private BundleContext bundleContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ServiceReference<?>> pendingRefs = new ArrayList();
    @Reference
    private SlingScriptEngineManager scriptEngineManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile EventAdmin eventAdmin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        List<ServiceReference<?>> list = this.pendingRefs;
        synchronized (list) {
            for (ServiceReference<?> ref : this.pendingRefs) {
                this.addingService(ref);
            }
            this.pendingRefs.clear();
        }
        this.bvpTracker = new ServiceTracker(this.bundleContext, BindingsValuesProvider.class, new ProvidersServiceTrackerCustomizer());
        this.bvpTracker.open();
        this.mapsTracker = new ServiceTracker(this.bundleContext, Map.class, new ProvidersServiceTrackerCustomizer());
        this.mapsTracker.open();
    }

    @Deactivate
    public void deactivate(ComponentContext ctx) {
        this.bvpTracker.close();
        this.mapsTracker.close();
        this.bundleContext = null;
    }

    public Collection<BindingsValuesProvider> getBindingsValuesProviders(ScriptEngineFactory scriptEngineFactory, String context) {
        ContextBvpCollector bvpc;
        ArrayList<BindingsValuesProvider> results = new ArrayList<BindingsValuesProvider>();
        if (context == null) {
            context = "request";
        }
        if ((bvpc = this.customizers.get(context)) == null) {
            this.logger.debug("no BindingsValuesProviderCustomizer available for context '{}'", (Object)context);
            return results;
        }
        results.addAll(bvpc.getGenericBindingsValuesProviders().values());
        this.logger.debug("Generic BindingsValuesProviders added for engine {}: {}", scriptEngineFactory.getNames(), results);
        Map<String, Object> factoryProperties = this.scriptEngineManager.getServiceProperties(scriptEngineFactory);
        if (factoryProperties != null) {
            String[] compatibleLangs;
            for (String name : compatibleLangs = (String[])Converters.standardConverter().convert(factoryProperties.get("compatible.javax.script.name")).to(String[].class)) {
                Map<ServiceReference<?>, BindingsValuesProvider> langProviders = bvpc.getLangBindingsValuesProviders().get(name);
                if (langProviders == null) continue;
                results.addAll(langProviders.values());
            }
            this.logger.debug("Compatible BindingsValuesProviders added for engine {}: {}", scriptEngineFactory.getNames(), results);
        }
        for (String name : scriptEngineFactory.getNames()) {
            Map<ServiceReference<?>, BindingsValuesProvider> langProviders = bvpc.getLangBindingsValuesProviders().get(name);
            if (langProviders == null) continue;
            results.addAll(langProviders.values());
        }
        this.logger.debug("All BindingsValuesProviders added for engine {}: {}", scriptEngineFactory.getNames(), results);
        return results;
    }

    private Event newEvent(String topic, ServiceReference<?> reference) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.id", reference.getProperty("service.id"));
        return new Event(topic, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addingService(final ServiceReference<?> reference) {
        if (this.bundleContext == null) {
            List<ServiceReference<?>> list = this.pendingRefs;
            synchronized (list) {
                this.pendingRefs.add(reference);
            }
            return null;
        }
        return new ContextLoop(){

            @Override
            protected void applyInContext(ContextBvpCollector c) {
                c.addingService(reference);
                if (BindingsValuesProvidersByContextImpl.this.eventAdmin != null) {
                    BindingsValuesProvidersByContextImpl.this.eventAdmin.postEvent(BindingsValuesProvidersByContextImpl.this.newEvent(BindingsValuesProvidersByContextImpl.TOPIC_CREATED, reference));
                }
            }
        }.apply(reference);
    }

    private class ProvidersServiceTrackerCustomizer<S, T>
    implements ServiceTrackerCustomizer<S, T> {
        private ProvidersServiceTrackerCustomizer() {
        }

        public T addingService(ServiceReference<S> reference) {
            return (T)BindingsValuesProvidersByContextImpl.this.addingService(reference);
        }

        public void modifiedService(final ServiceReference<S> reference, T service) {
            new ContextLoop(){

                @Override
                protected void applyInContext(ContextBvpCollector c) {
                    c.modifiedService(reference);
                    if (BindingsValuesProvidersByContextImpl.this.eventAdmin != null) {
                        BindingsValuesProvidersByContextImpl.this.eventAdmin.postEvent(BindingsValuesProvidersByContextImpl.this.newEvent(BindingsValuesProvidersByContextImpl.TOPIC_MODIFIED, reference));
                    }
                }
            }.apply(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(final ServiceReference<S> reference, T service) {
            if (BindingsValuesProvidersByContextImpl.this.bundleContext == null) {
                List<ServiceReference<?>> list = BindingsValuesProvidersByContextImpl.this.pendingRefs;
                synchronized (list) {
                    BindingsValuesProvidersByContextImpl.this.pendingRefs.remove(reference);
                }
                return;
            }
            new ContextLoop(){

                @Override
                protected void applyInContext(ContextBvpCollector c) {
                    c.removedService(reference);
                    if (BindingsValuesProvidersByContextImpl.this.eventAdmin != null) {
                        BindingsValuesProvidersByContextImpl.this.eventAdmin.postEvent(BindingsValuesProvidersByContextImpl.this.newEvent(BindingsValuesProvidersByContextImpl.TOPIC_REMOVED, reference));
                    }
                }
            }.apply(reference);
        }
    }

    private abstract class ContextLoop {
        private ContextLoop() {
        }

        private String[] getContexts(ServiceReference<?> reference) {
            return (String[])((Converting)Converters.standardConverter().convert(reference.getProperty("context")).defaultValue((Object)DEFAULT_CONTEXT_ARRAY)).to(String[].class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object apply(ServiceReference<?> ref) {
            Object service = BindingsValuesProvidersByContextImpl.this.bundleContext.getService(ref);
            if (service != null) {
                for (String context : this.getContexts(ref)) {
                    ContextBvpCollector c = BindingsValuesProvidersByContextImpl.this.customizers.get(context);
                    if (c == null) {
                        BindingsValuesProvidersByContextImpl bindingsValuesProvidersByContextImpl = BindingsValuesProvidersByContextImpl.this;
                        synchronized (bindingsValuesProvidersByContextImpl) {
                            c = new ContextBvpCollector(BindingsValuesProvidersByContextImpl.this.bundleContext);
                            BindingsValuesProvidersByContextImpl.this.customizers.put(context, c);
                        }
                    }
                    this.applyInContext(c);
                }
            }
            return service;
        }

        protected abstract void applyInContext(ContextBvpCollector var1);
    }
}

