/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.Servlet;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class CallTag
extends TagSupport {
    private static final long serialVersionUID = 5446209582533607741L;
    private String script;
    private boolean flush;
    private boolean ignoreComponentHierarchy;

    public int doEndTag() throws JspException {
        Servlet servlet;
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        ServletResolver servletResolver = (ServletResolver)scriptHelper.getService(ServletResolver.class);
        RequestProgressTracker tracker = TagUtil.getRequest((PageContext)this.pageContext).getRequestProgressTracker();
        String servletName = null;
        if (!this.ignoreComponentHierarchy) {
            Resource resource = bindings.getResource();
            servlet = servletResolver.resolveServlet(resource, this.script);
            if (servlet != null) {
                servletName = RequestUtil.getServletName((Servlet)servlet);
                tracker.log("Including script {0} for path={1}, type={2}: {3}", new Object[]{this.script, resource.getPath(), resource.getResourceType(), servletName});
            }
        } else {
            String scriptPath;
            ResourceResolver resolver = bindings.getRequest().getResourceResolver();
            if (!this.script.startsWith("/")) {
                String parentPath = ResourceUtil.getParent((String)scriptHelper.getScript().getScriptResource().getPath());
                for (String sp : resolver.getSearchPath()) {
                    if (!parentPath.startsWith(sp)) continue;
                    parentPath = parentPath.substring(sp.length());
                    break;
                }
                scriptPath = parentPath + "/" + this.script;
            } else {
                scriptPath = this.script;
            }
            servlet = servletResolver.resolveServlet(resolver, scriptPath);
            if (servlet != null) {
                servletName = RequestUtil.getServletName((Servlet)servlet);
                tracker.log("Including script {0} (ignoring component hierarchy): {1}", new Object[]{this.script, servletName});
            }
        }
        if (servlet == null) {
            throw new JspException("Could not find script " + this.script);
        }
        try {
            if (this.flush && !(this.pageContext.getOut() instanceof BodyContent)) {
                this.pageContext.getOut().flush();
            }
            JspSlingHttpServletResponseWrapper response = new JspSlingHttpServletResponseWrapper(this.pageContext);
            tracker.startTimer(servletName);
            servlet.service(this.pageContext.getRequest(), (ServletResponse)response);
            tracker.logTimer(servletName);
            return 6;
        }
        catch (Exception e) {
            throw new JspException("Error while executing script " + this.script, (Throwable)e);
        }
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.script = null;
        this.flush = false;
        this.ignoreComponentHierarchy = false;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setIgnoreComponentHierarchy(boolean ignoreComponentHierarchy) {
        this.ignoreComponentHierarchy = ignoreComponentHierarchy;
    }
}

