/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.jsp.taglib.internal.XSSSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodeTag
extends BodyTagSupport {
    private static final long serialVersionUID = 5673936481350419997L;
    private static final Logger log = LoggerFactory.getLogger(EncodeTag.class);
    private String value;
    private String defaultValue;
    private XSSSupport.EncodingMode mode;
    private boolean readBody = false;

    public int doEndTag() throws JspException {
        log.trace("doEndTag");
        if (this.readBody && this.bodyContent != null && this.bodyContent.getString() != null) {
            String encoded = XSSSupport.encode(this.bodyContent.getString(), this.mode);
            this.write(encoded);
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        int res = 0;
        String unencoded = this.value;
        if (StringUtils.isBlank((CharSequence)unencoded)) {
            unencoded = this.defaultValue;
        }
        if (unencoded != null) {
            String encoded = XSSSupport.encode(unencoded, this.mode);
            this.write(encoded);
        } else {
            this.readBody = true;
            res = 2;
        }
        return res;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getMode() {
        return this.mode.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setMode(String mode) {
        this.mode = XSSSupport.getEncodingMode(mode);
    }

    public void setValue(String value) {
        this.value = value;
    }

    private void write(String encoded) throws JspException {
        if (encoded != null && !encoded.isEmpty()) {
            try {
                this.pageContext.getOut().write(encoded);
            }
            catch (IOException e) {
                log.error("Exception writing escaped content to page", (Throwable)e);
                throw new JspException("Exception writing escaped content to page", (Throwable)e);
            }
        }
    }
}

