/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.servlethelpers.internalrequests.JakartaInternalRequest;
import org.apache.sling.servlethelpers.internalrequests.ServletResolutionResource;
import org.jetbrains.annotations.NotNull;

public class JakartaSlingInternalRequest
extends JakartaInternalRequest {
    private final SlingRequestProcessor processor;
    private String resourceType;
    private String resourceSuperType;

    public JakartaSlingInternalRequest(@NotNull ResourceResolver resourceResolver, @NotNull SlingRequestProcessor p, @NotNull String path) {
        super(resourceResolver, path);
        this.checkNotNull(SlingRequestProcessor.class, (Object)p);
        this.processor = p;
    }

    public String toString() {
        return String.format("%s: %s P=%s S=%s EXT=%s RT=%s(%s)", this.getClass().getSimpleName(), this.requestMethod, this.path, this.selectorString, this.extension, this.resourceType, this.resourceSuperType);
    }

    public JakartaSlingInternalRequest withResourceSuperType(String resourceSuperType) {
        this.resourceSuperType = resourceSuperType;
        return this;
    }

    public JakartaSlingInternalRequest withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    protected void delegateExecute(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response, ResourceResolver resourceResolver) throws ServletException, IOException {
        this.log.debug("Executing request using a SlingRequestProcessor");
        this.processor.processRequest((HttpServletRequest)request, (HttpServletResponse)response, resourceResolver);
    }

    @Override
    protected Resource getExecutionResource() {
        return new ServletResolutionResource(this.resourceResolver, this.path, this.resourceType, this.resourceSuperType);
    }
}

