/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.get.impl.helpers.Renderer;

public class PlainTextRenderer
implements Renderer {
    @Override
    public void render(SlingJakartaHttpServletRequest req, SlingJakartaHttpServletResponse resp) throws IOException {
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        Map map = (Map)r.adaptTo(Map.class);
        if (map != null) {
            this.dump(pw, r, map);
        } else if (r.adaptTo(String.class) != null) {
            this.printPropertyValue(pw, r.getName(), r.adaptTo(String.class), false);
        } else if (r.adaptTo(String[].class) != null) {
            this.printPropertyValue(pw, r.getName(), r.adaptTo(String[].class), false);
        } else {
            resp.sendError(204);
        }
    }

    protected void dump(PrintWriter pw, Resource r, Map<String, Object> map) {
        pw.println("** Resource dumped by " + this.getClass().getSimpleName() + "**");
        pw.println("Resource path:" + r.getPath());
        pw.println("Resource metadata: " + String.valueOf(r.getResourceMetadata()));
        pw.println("Resource type: " + r.getResourceType());
        String resourceSuperType = r.getResourceResolver().getParentResourceType(r);
        if (resourceSuperType == null) {
            resourceSuperType = "-";
        }
        pw.println("Resource super type: " + resourceSuperType);
        pw.println("\n** Resource properties **");
        for (Map.Entry<String, Object> p : map.entrySet()) {
            this.printPropertyValue(pw, p.getKey(), p.getValue(), true);
            pw.println();
        }
    }

    protected void printPropertyValue(PrintWriter pw, String name, Object value, boolean includeName) {
        if (includeName) {
            pw.print(name + ": ");
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            pw.print('[');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(values[i].toString());
            }
            pw.print(']');
        } else {
            pw.print(value.toString());
        }
    }
}

