/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.defaults;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.request.header.MediaRangeList;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "sling.servlet.paths=sling/servlet/errorhandler/default", "sling.servlet.prefix=-1"})
public class DefaultErrorHandlerServlet
extends GenericServlet {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private final transient Logger log = LoggerFactory.getLogger(DefaultErrorHandlerServlet.class);

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        int statusCode;
        Integer scObject = (Integer)req.getAttribute("javax.servlet.error.status_code");
        String statusMessage = (String)req.getAttribute("javax.servlet.error.message");
        String requestUri = (String)req.getAttribute("javax.servlet.error.request_uri");
        String servletName = (String)req.getAttribute("javax.servlet.error.servlet_name");
        int n = statusCode = scObject != null ? scObject : 500;
        if (statusMessage == null) {
            statusMessage = DefaultErrorHandlerServlet.statusToString(statusCode);
        }
        if (req instanceof HttpServletRequest && JSON_CONTENT_TYPE.equals(new MediaRangeList((HttpServletRequest)req).prefer(new String[]{HTML_CONTENT_TYPE, JSON_CONTENT_TYPE}))) {
            this.renderJson(req, res, statusMessage, requestUri, servletName, statusCode);
        } else {
            this.renderHtml(req, res, statusMessage, requestUri, servletName, statusCode);
        }
    }

    protected void renderHtml(ServletRequest req, ServletResponse res, String statusMessage, String requestUri, String servletName, int statusCode) throws IOException {
        PrintWriter pw = this.sendIntro((HttpServletResponse)res, statusCode, statusMessage, requestUri, servletName);
        PrintWriter escapingWriter = new PrintWriter(ResponseUtil.getXmlEscapingWriter((Writer)pw));
        if (req.getAttribute("javax.servlet.error.exception") instanceof Throwable) {
            Throwable throwable = (Throwable)req.getAttribute("javax.servlet.error.exception");
            pw.println("<h3>Exception:</h3>");
            pw.println("<pre>");
            pw.flush();
            this.printStackTrace(escapingWriter, throwable);
            escapingWriter.flush();
            pw.println("</pre>");
        }
        if (req instanceof SlingHttpServletRequest) {
            RequestProgressTracker tracker = ((SlingHttpServletRequest)req).getRequestProgressTracker();
            pw.println("<h3>Request Progress:</h3>");
            pw.println("<pre>");
            pw.flush();
            tracker.dump(escapingWriter);
            escapingWriter.flush();
            pw.println("</pre>");
        }
        this.sendEpilogue(pw);
    }

    protected void renderJson(ServletRequest req, ServletResponse res, String statusMessage, String requestUri, String servletName, int statusCode) throws IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        response.setStatus(statusCode);
        response.setContentType(JSON_CONTENT_TYPE);
        response.setCharacterEncoding("UTF-8");
        try (JsonGenerator jsonGenerator = Json.createGenerator((Writer)res.getWriter());){
            jsonGenerator.writeStartObject();
            jsonGenerator.write("status", statusCode);
            String msg = (String)req.getAttribute("javax.servlet.error.message");
            if (msg != null && !msg.isEmpty()) {
                jsonGenerator.write("message", statusMessage);
            }
            if (requestUri != null && !requestUri.isEmpty()) {
                jsonGenerator.write("requestUri", requestUri);
            }
            if (servletName != null && !servletName.isEmpty()) {
                jsonGenerator.write("servletName", servletName);
            }
            Object exceptionTypeObj = req.getAttribute("javax.servlet.error.exception_type");
            String exceptionType = null;
            if (exceptionTypeObj instanceof String) {
                exceptionType = (String)exceptionTypeObj;
            } else if (exceptionTypeObj instanceof Class) {
                exceptionType = ((Class)exceptionTypeObj).getName();
            }
            if (exceptionType != null && !exceptionType.isEmpty()) {
                jsonGenerator.write("exceptionType", exceptionType);
            }
            if (req.getAttribute("javax.servlet.error.exception") instanceof Throwable) {
                Throwable throwable = (Throwable)req.getAttribute("javax.servlet.error.exception");
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    this.printStackTrace(pw, throwable);
                    jsonGenerator.write("exception", sw.toString());
                }
            }
            if (req instanceof SlingHttpServletRequest) {
                RequestProgressTracker tracker = ((SlingHttpServletRequest)req).getRequestProgressTracker();
                StringWriter strWriter = new StringWriter();
                try (PrintWriter progressWriter = new PrintWriter(strWriter);){
                    tracker.dump(progressWriter);
                }
                jsonGenerator.write("requestProgress", strWriter.toString());
            }
            jsonGenerator.writeEnd();
        }
    }

    private void printStackTrace(PrintWriter pw, Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof ServletException) {
            ServletException se = (ServletException)t;
            while (se.getRootCause() != null && (t = se.getRootCause()) instanceof ServletException) {
                se = (ServletException)t;
            }
        }
        t.printStackTrace(pw);
    }

    private PrintWriter sendIntro(HttpServletResponse response, int statusCode, String statusMessageIn, String requestUri, String servletName) throws IOException {
        PrintWriter pw;
        String statusMessage = ResponseUtil.escapeXml((String)statusMessageIn);
        if (!response.isCommitted()) {
            response.reset();
            response.setStatus(statusCode);
            response.setContentType(HTML_CONTENT_TYPE);
            response.setCharacterEncoding("UTF-8");
            pw = response.getWriter();
            pw.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">");
            pw.println("<html>");
            pw.println("<head>");
            pw.print("<title>");
            pw.print(statusCode);
            pw.print(" ");
            pw.print(statusMessage);
            pw.println("</title>");
            pw.println("</head>");
            pw.println("<body>");
        } else {
            this.log.warn("Response already committed, unable to change status, output might not be well formed");
            pw = response.getWriter();
        }
        pw.print("<h1>");
        pw.print(statusMessage);
        pw.print(" (");
        pw.print(statusCode);
        pw.println(")</h1>");
        pw.print("<p>The requested URL ");
        pw.print(ResponseUtil.escapeXml((String)requestUri));
        pw.print(" resulted in an error");
        if (servletName != null) {
            pw.print(" in ");
            pw.print(ResponseUtil.escapeXml((String)servletName));
        }
        pw.println(".</p>");
        return pw;
    }

    private void sendEpilogue(PrintWriter pw) {
        pw.println("<hr>");
        pw.print("<address>");
        pw.print(ResponseUtil.escapeXml((String)this.getServletContext().getServerInfo()));
        pw.println("</address>");
        pw.println("</body>");
        pw.println("</html>");
    }

    public static String statusToString(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing (WebDAV)";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status (WebDAV)";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested range not satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 422: {
                return "Unprocessable Entity (WebDAV)";
            }
            case 423: {
                return "Locked (WebDAV)";
            }
            case 424: {
                return "Failed Dependency (WebDAV)";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
            case 507: {
                return "Insufficient Storage (WebDAV)";
            }
            case 510: {
                return "Not Extended";
            }
        }
        return String.valueOf(statusCode);
    }
}

