/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder.extensions;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.builder.extensions.GoogleNewsExtension;
import org.apache.sling.sitemap.spi.builder.AbstractExtension;
import org.apache.sling.sitemap.spi.builder.SitemapExtensionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"extension.interface=org.apache.sling.sitemap.builder.extensions.GoogleNewsExtension", "extension.prefix=news", "extension.namespace=http://www.google.com/schemas/sitemap-news/0.9", "extension.localName=news"})
public class GoogleNewsExtensionProvider
implements SitemapExtensionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleNewsExtensionProvider.class);
    private static final Pattern STOCK_TICKER_PATTERN = Pattern.compile("\\w+:\\w+");

    @Override
    public AbstractExtension newInstance() {
        return new ExtensionImpl();
    }

    private static class ExtensionImpl
    extends AbstractExtension
    implements GoogleNewsExtension {
        private String publicationName;
        private String publicationLanguage;
        private String publicationDate;
        private String title;
        private String accessRestriction;
        private String genres;
        private String keywords;
        private String stockTickers;

        private ExtensionImpl() {
        }

        @Override
        @NotNull
        public GoogleNewsExtension setPublication(@NotNull String name, @NotNull Locale locale) {
            this.publicationName = name;
            String languageTag = locale.toLanguageTag().toLowerCase(Locale.ROOT);
            this.publicationLanguage = languageTag.equals("zh-cn") || languageTag.equals("zh-tw") ? languageTag : locale.getLanguage().toLowerCase(Locale.ROOT);
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setPublicationDate(@NotNull OffsetDateTime date) {
            this.publicationDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(date);
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setPublicationDate(@NotNull LocalDate date) {
            this.publicationDate = DateTimeFormatter.ISO_LOCAL_DATE.format(date);
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setTitle(@NotNull String title) {
            this.title = title;
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setAccessRestriction(GoogleNewsExtension.AccessRestriction accessRestriction) {
            this.accessRestriction = accessRestriction != null ? accessRestriction.getValue() : null;
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setGenres(@Nullable Collection<GoogleNewsExtension.Genre> genres) {
            this.genres = genres != null && !genres.isEmpty() ? genres.stream().map(GoogleNewsExtension.Genre::getValue).collect(Collectors.joining(",")) : null;
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setKeywords(@Nullable Collection<String> keywords) {
            this.keywords = keywords != null && !keywords.isEmpty() ? String.join((CharSequence)",", keywords) : null;
            return this;
        }

        @Override
        @NotNull
        public GoogleNewsExtension setStockTickers(@Nullable Collection<String> stockTickers) {
            if (stockTickers != null) {
                if (stockTickers.size() > 5) {
                    LOG.warn("Adjusting stock tickers as they are out of bounds (0,5): {}", (Object)stockTickers.size());
                }
                this.stockTickers = stockTickers.stream().filter(stockTicker -> STOCK_TICKER_PATTERN.matcher((CharSequence)stockTicker).matches()).limit(5L).collect(Collectors.joining(","));
            } else {
                this.stockTickers = null;
            }
            return this;
        }

        @Override
        public void writeTo(@NotNull XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("publication");
            writer.writeStartElement("name");
            writer.writeCharacters(ExtensionImpl.required(this.publicationName, "publication name missing"));
            writer.writeEndElement();
            writer.writeStartElement("language");
            writer.writeCharacters(ExtensionImpl.required(this.publicationLanguage, "publication language missing"));
            writer.writeEndElement();
            writer.writeEndElement();
            if (this.accessRestriction != null) {
                writer.writeStartElement("access");
                writer.writeCharacters(this.accessRestriction);
                writer.writeEndElement();
            }
            if (this.genres != null) {
                writer.writeStartElement("genres");
                writer.writeCharacters(this.genres);
                writer.writeEndElement();
            }
            writer.writeStartElement("publication_date");
            writer.writeCharacters(ExtensionImpl.required(this.publicationDate, "publication date missing"));
            writer.writeEndElement();
            writer.writeStartElement("title");
            writer.writeCharacters(ExtensionImpl.required(this.title, "title missing"));
            writer.writeEndElement();
            if (this.keywords != null) {
                writer.writeStartElement("keywords");
                writer.writeCharacters(this.keywords);
                writer.writeEndElement();
            }
            if (this.stockTickers != null) {
                writer.writeStartElement("stock_tickers");
                writer.writeCharacters(this.stockTickers);
                writer.writeEndElement();
            }
        }

        private static String required(String object, String message) throws XMLStreamException {
            if (object == null) {
                throw new XMLStreamException(message);
            }
            return object;
        }
    }
}

