/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.startup.impl;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.starter.startup.impl.HttpStartupSetup;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private final String[] REQUIRED_SERVICES = new String[]{"org.apache.sling.api.auth.Authenticator", "org.apache.sling.api.resource.ResourceResolverFactory", "org.apache.sling.api.servlets.ServletResolver"};
    private volatile ServiceTracker<InfoProvider, InfoProvider> infoProviderTracker;
    private volatile HttpStartupSetup httpSetup;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public void start(BundleContext context) {
        this.httpSetup = new HttpStartupSetup(context);
        this.httpSetup.start();
        this.setupInfoProviderTracker(context);
    }

    public void stop(BundleContext context) {
        this.stopped.set(true);
        this.stopInfoProviderTracker();
        if (this.httpSetup != null) {
            this.httpSetup.stop();
            this.httpSetup = null;
        }
    }

    private void setupInfoProviderTracker(final BundleContext context) {
        this.infoProviderTracker = new ServiceTracker(context, InfoProvider.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<InfoProvider, InfoProvider>(){
            private final AtomicInteger counter = new AtomicInteger();
            private final Timer timer = new Timer();

            public InfoProvider addingService(ServiceReference<InfoProvider> reference) {
                if (Activator.this.stopped.get()) {
                    return null;
                }
                InfoProvider service = (InfoProvider)context.getService(reference);
                if (this.counter.incrementAndGet() == 1) {
                    this.startCheck(service);
                }
                return service;
            }

            public void modifiedService(ServiceReference<InfoProvider> reference, InfoProvider service) {
            }

            public void removedService(ServiceReference<InfoProvider> reference, InfoProvider service) {
                if (this.counter.decrementAndGet() == 0) {
                    this.stopCheck();
                }
                context.ungetService(reference);
            }

            private void startCheck(final InfoProvider service) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        InstallationState state = service.getInstallationState();
                        if (state.getActiveResources().isEmpty() && state.getUntransformedResources().isEmpty() && Activator.this.checkServices(context)) {
                            Activator.this.httpSetup.stop();
                            this.cancel();
                        }
                    }
                };
                this.timer.schedule(task, 1000L, 1000L);
            }

            private void stopCheck() {
                this.timer.cancel();
                if (!Activator.this.stopped.get()) {
                    Activator.this.httpSetup.start();
                }
            }
        });
        this.infoProviderTracker.open();
    }

    private void stopInfoProviderTracker() {
        if (this.infoProviderTracker != null) {
            this.infoProviderTracker.close();
            this.infoProviderTracker = null;
        }
    }

    private boolean checkServices(BundleContext context) {
        for (String name : this.REQUIRED_SERVICES) {
            ServiceReference ref = context.getServiceReference(name);
            if (ref == null) {
                return false;
            }
            Object service = context.getService(ref);
            if (service == null) {
                return false;
            }
            context.ungetService(ref);
        }
        return true;
    }
}

