/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.serversetup;

import java.util.Properties;
import org.apache.sling.testing.serversetup.ServerSetup;
import org.apache.sling.testing.serversetup.SetupPhase;
import org.apache.sling.testing.serversetup.jarexec.JarExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartRunnableJarPhase
implements SetupPhase {
    public static final String TEST_SERVER_HOSTNAME = "test.server.hostname";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final String description;
    private final JarExecutor executor;

    public StartRunnableJarPhase(ServerSetup owner, String id, String description, Properties config) throws JarExecutor.ExecutorException {
        this.id = id;
        this.description = description;
        this.executor = new JarExecutor(config);
        String hostname = config.getProperty(TEST_SERVER_HOSTNAME);
        if (hostname == null) {
            hostname = "localhost";
        }
        String url = "http://" + hostname + ":" + this.executor.getServerPort();
        this.log.info("Server base URL={}", (Object)url);
        owner.getContext().put("server.base.url", url);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.id + ") " + this.description;
    }

    @Override
    public void run(ServerSetup owner) throws Exception {
        this.executor.start();
    }

    @Override
    public boolean isStartupPhase() {
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public SetupPhase getKillPhase(final String id) {
        return new SetupPhase(){

            @Override
            public void run(ServerSetup owner) throws Exception {
                StartRunnableJarPhase.this.executor.stop();
            }

            @Override
            public boolean isStartupPhase() {
                return true;
            }

            public String toString() {
                return "Kill the process started by " + StartRunnableJarPhase.this;
            }

            @Override
            public String getId() {
                return id;
            }
        };
    }
}

