/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.commons.query.qom.JoinType;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.join.Join;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.lucene.index.IndexReader;

public class JoinQuery
implements MultiColumnQuery {
    private final MultiColumnQuery left;
    private final MultiColumnQuery right;
    private final JoinType joinType;
    private final JoinConditionImpl joinCondition;
    private final NamespaceMappings nsMappings;
    private final HierarchyManager hmgr;

    public JoinQuery(MultiColumnQuery left, MultiColumnQuery right, JoinType joinType, JoinConditionImpl joinCondition, NamespaceMappings nsMappings, HierarchyManager hmgr) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
        this.nsMappings = nsMappings;
        this.hmgr = hmgr;
    }

    public MultiColumnQueryHits execute(JackrabbitIndexSearcher searcher, Ordering[] orderings, long resultFetchHint) throws IOException {
        IndexReader reader = searcher.getIndexReader();
        HierarchyResolver resolver = (HierarchyResolver)reader;
        return Join.create(this.left.execute(searcher, orderings, resultFetchHint), this.right.execute(searcher, orderings, resultFetchHint), this.joinType, this.joinCondition, reader, resolver, this.nsMappings, this.hmgr);
    }
}

