/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.thumbnails.BadRequestException;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum OutputFileFormat {
    GIF("image/gif"),
    JPEG("image/jpeg"),
    PNG("image/png");

    private String mimeType;

    public static OutputFileFormat forRequest(SlingHttpServletRequest request) {
        return OutputFileFormat.forValue(StringUtils.substringAfterLast((String)request.getRequestPathInfo().getSuffix(), (String)"."));
    }

    public static OutputFileFormat forValue(@NotNull String format) {
        if ("JPG".equals(format = format.toUpperCase())) {
            format = "JPEG";
        }
        try {
            return Enum.valueOf(OutputFileFormat.class, format);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new BadRequestException("Could not get valid extension from: " + format);
        }
    }

    private OutputFileFormat(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

