/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.thumbnails.Transformation;
import org.apache.sling.thumbnails.internal.TransformationServiceUser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Runnable.class, TransformationCache.class, EventHandler.class}, property={"event.topics=org/apache/sling/api/resource/Resource/CHANGED", "event.filter=(&(resourceType=sling/thumbnails/transformation))", "scheduler.period=L3600"})
public class TransformationCache
implements EventHandler,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(TransformationCache.class);
    private final TransformationServiceUser transformationServiceUser;
    private final Map<String, Optional<String>> cache = new HashMap<String, Optional<String>>();

    @Activate
    public TransformationCache(@Reference TransformationServiceUser transformationServiceUser) {
        this.transformationServiceUser = transformationServiceUser;
    }

    public Optional<Transformation> getTransformation(ResourceResolver resolver, String name) {
        return this.cache.computeIfAbsent(name, this::findTransformation).map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).map(r -> (Transformation)r.adaptTo(Transformation.class));
    }

    public void handleEvent(Event event) {
        this.cache.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> findTransformation(String name) {
        try (ResourceResolver serviceResolver = this.transformationServiceUser.getTransformationServiceUser();){
            name = name.substring(1).replace("'", "''");
            log.debug("Finding transformations with {}", (Object)name);
            Iterator transformations = serviceResolver.findResources("SELECT * FROM [nt:unstructured] WHERE (ISDESCENDANTNODE([/conf]) OR ISDESCENDANTNODE([/libs/conf]) OR ISDESCENDANTNODE([/apps/conf])) AND [sling:resourceType]='sling/thumbnails/transformation' AND [name]='" + name + "'", "JCR-SQL2");
            if (transformations.hasNext()) {
                Resource transformation = (Resource)transformations.next();
                log.debug("Found transformation resource: {}", (Object)transformation);
                Optional<String> optional2 = Optional.of(transformation.getPath());
                return optional2;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (LoginException le) {
            throw new RuntimeException("Could not get service resolver", le);
        }
    }

    public Set<Map.Entry<String, Optional<String>>> getCacheEntries() {
        return this.cache.entrySet();
    }

    @Override
    public void run() {
        this.cache.clear();
    }
}

