/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.tracer.internal.CallerFilter;
import org.apache.sling.tracer.internal.PrefixExcludeFilter;

class CallerStackReporter {
    private static final CallerFilter FWK_EXCLUDE_FILTER = new PrefixExcludeFilter(Arrays.asList("java.lang.Thread", "org.apache.sling.tracer.internal", "ch.qos.logback.classic", "sun.reflect", "java.lang.reflect"));
    private final CallerFilter callerFilter;
    private final int start;
    private final int depth;

    public CallerStackReporter(int depth) {
        this(0, depth, CallerFilter.ALL);
    }

    public CallerStackReporter(int start, int depth, CallerFilter filter) {
        this.start = start;
        this.depth = depth;
        this.callerFilter = filter;
    }

    public List<StackTraceElement> report() {
        return this.report(Thread.currentThread().getStackTrace());
    }

    public List<StackTraceElement> report(StackTraceElement[] stack) {
        List<StackTraceElement> filteredStack = this.fwkExcludedStack(stack);
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(filteredStack.size());
        for (int i = 0; i < filteredStack.size(); ++i) {
            StackTraceElement ste = filteredStack.get(i);
            if (i < this.start || i >= this.depth || !this.callerFilter.include(ste)) continue;
            result.add(ste);
        }
        return result;
    }

    private List<StackTraceElement> fwkExcludedStack(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> filteredStack = new ArrayList<StackTraceElement>(stack.length);
        for (StackTraceElement ste : stack) {
            if (!FWK_EXCLUDE_FILTER.include(ste)) continue;
            filteredStack.add(ste);
        }
        return filteredStack;
    }

    public CallerFilter getCallerFilter() {
        return this.callerFilter;
    }

    public int getStart() {
        return this.start;
    }

    public int getDepth() {
        return this.depth;
    }
}

