/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.provisioning.model.ModelUtility;

public abstract class AbstractSlingStartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/provisioning")
    private File modelDirectory;
    @Parameter(defaultValue="((.*)\\.txt|(.*)\\.model)")
    private String modelPattern;
    public static final String DEFAULT_MODEL_PATTERN = "((.*)\\.txt|(.*)\\.model)";
    @Parameter
    private String model;
    static final String CONFIGURATION_NAME_DISABLE_EXTENDING_CLASSPATH = "disableExtendingMavenClasspath";
    @Parameter(name="disableExtendingMavenClasspath")
    private boolean disableExtendingMavenClasspath;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="false")
    protected boolean usePomVariables;
    @Parameter(defaultValue="false")
    protected boolean usePomDependencies;
    @Parameter(defaultValue="false")
    protected boolean allowUnresolvedPomDependencies;

    protected File getTmpDir() {
        return new File(this.project.getBuild().getDirectory(), "slingstart-tmp");
    }

    protected ModelUtility.ResolverOptions getResolverOptions() {
        ModelUtility.ResolverOptions options = new ModelUtility.ResolverOptions();
        if (this.usePomVariables) {
            options.variableResolver((ModelUtility.VariableResolver)new PomVariableResolver(this.project));
        }
        if (this.usePomDependencies) {
            options.artifactVersionResolver((ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(this.project, this.allowUnresolvedPomDependencies));
        }
        return options;
    }

    protected File getStandaloneOutputDirectory() {
        return new File(this.getTmpDir(), "standalone");
    }
}

