/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Locale;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextMeasurerFactory;

public final class JRTextMeasurerUtil {
    private final FontUtil fontUtil;
    private final JasperReportsContext jasperReportsContext;
    private final JRStyledTextAttributeSelector noBackcolorSelector;
    private final JRStyledTextUtil styledTextUtil;
    public static final String PROPERTY_TEXT_MEASURER_FACTORY = "net.sf.jasperreports.text.measurer.factory";
    private static final JRSingletonCache<JRTextMeasurerFactory> cache = new JRSingletonCache<JRTextMeasurerFactory>(JRTextMeasurerFactory.class);

    private JRTextMeasurerUtil(FontUtil fontUtil) {
        this.fontUtil = fontUtil;
        this.jasperReportsContext = fontUtil.getJasperReportsContext();
        this.noBackcolorSelector = JRStyledTextAttributeSelector.getNoBackcolorSelector(this.jasperReportsContext);
        this.styledTextUtil = JRStyledTextUtil.getInstance(this.jasperReportsContext);
    }

    public static JRTextMeasurerUtil getInstance(JasperReportsContext jasperReportsContext) {
        return JRTextMeasurerUtil.getInstance(FontUtil.getInstance(jasperReportsContext));
    }

    public static JRTextMeasurerUtil getInstance(FontUtil fontUtil) {
        return new JRTextMeasurerUtil(fontUtil);
    }

    public JRTextMeasurer createTextMeasurer(JRCommonText text) {
        JRPropertiesHolder propertiesHolder = text instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)text) : null;
        return this.createTextMeasurer(text, propertiesHolder);
    }

    public JRTextMeasurer createTextMeasurer(JRCommonText text, JRPropertiesHolder propertiesHolder) {
        JRTextMeasurerFactory factory = this.getFactory(propertiesHolder);
        return factory.createMeasurer(this.fontUtil, text);
    }

    public JRTextMeasurerFactory getFactory(JRPropertiesHolder propertiesHolder) {
        String factoryClass = this.getTextMeasurerFactoryClass(propertiesHolder);
        try {
            return cache.getCachedInstance(factoryClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String getTextMeasurerFactoryClass(JRPropertiesHolder propertiesHolder) {
        String factory = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, PROPERTY_TEXT_MEASURER_FACTORY);
        String factoryClassProperty = "net.sf.jasperreports.text.measurer.factory." + factory;
        String factoryClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, factoryClassProperty);
        if (factoryClass == null) {
            factoryClass = factory;
        }
        return factoryClass;
    }

    public void measureTextElement(JRPrintText printText) {
        String text = this.styledTextUtil.getTruncatedText(printText);
        JRTextMeasurer textMeasurer = this.createTextMeasurer(printText);
        if (text == null) {
            text = "";
        }
        Locale textLocale = JRStyledTextAttributeSelector.getTextLocale(printText);
        JRStyledText styledText = JRStyledTextParser.getInstance().getStyledText(this.noBackcolorSelector.getStyledTextAttributes(printText), text, "styled".equals(printText.getMarkup()), textLocale);
        JRStyledText processedStyledText = this.styledTextUtil.resolveFonts(styledText, textLocale);
        JRMeasuredText measuredText = textMeasurer.measure(processedStyledText, 0, 0, true, false);
        printText.setTextHeight(measuredText.getTextHeight() < (float)printText.getHeight() ? measuredText.getTextHeight() : (float)printText.getHeight());
        printText.setLeadingOffset(measuredText.getLeadingOffset());
        printText.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        int textEnd = measuredText.getTextOffset();
        String printedText = "styled".equals(printText.getMarkup()) ? JRStyledTextParser.getInstance().write(styledText, 0, textEnd) : text.substring(0, textEnd);
        printText.setText(printedText);
    }
}

