/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.NullFieldStrategy;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Hidden
implements ClientElement {
    @Parameter(required=true, autoconnect=true, principal=true)
    private Object value;
    @Parameter(defaultPrefix="nullfieldstrategy", value="default")
    private NullFieldStrategy nulls;
    @Parameter(required=true)
    private ValueEncoder encoder;
    private String clientId;
    private String controlName;
    private Element hiddenInputElement;
    @Environmental(value=false)
    private FormSupport formSupport;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private Request request;

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    boolean beginRender(MarkupWriter writer) {
        if (this.formSupport == null) {
            throw new RuntimeException("The Hidden component must be enclosed by a Form component.");
        }
        this.controlName = this.formSupport.allocateControlName(this.resources.getId());
        this.clientId = null;
        this.formSupport.store(this, new ProcessSubmission(this.controlName));
        Object toEncode = this.value == null ? this.nulls.replaceToClient() : this.value;
        String encoded = toEncode == null ? "" : this.encoder.toClient(toEncode);
        this.hiddenInputElement = writer.element("input", "type", "hidden", "name", this.controlName, "value", encoded);
        this.resources.renderInformalParameters(writer);
        writer.end();
        return false;
    }

    private void processSubmission(String controlName) {
        String encoded = this.request.getParameter(controlName);
        String toDecode = InternalUtils.isBlank((String)encoded) ? this.nulls.replaceFromClient() : encoded;
        Object decoded = toDecode == null ? null : this.encoder.toValue(toDecode);
        this.value = decoded;
    }

    @Override
    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.jsSupport.allocateClientId(this.resources);
            this.hiddenInputElement.forceAttributes("id", this.clientId);
        }
        return this.clientId;
    }

    public String getControlName() {
        return this.controlName;
    }

    static class ProcessSubmission
    implements ComponentAction<Hidden> {
        private final String controlName;

        public ProcessSubmission(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public void execute(Hidden component) {
            component.processSubmission(this.controlName);
        }
    }
}

