/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.CompressedStreamableResource;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackAssembler;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;
import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.ModuleManager;

public class JavaScriptStackAssemblerImpl
implements JavaScriptStackAssembler {
    private static final ContentType JAVASCRIPT_CONTENT_TYPE = new ContentType("text/javascript;charset=utf-8");
    private final ThreadLocale threadLocale;
    private final ResourceChangeTracker resourceChangeTracker;
    private final StreamableResourceSource streamableResourceSource;
    private final JavaScriptStackSource stackSource;
    private final AssetChecksumGenerator checksumGenerator;
    private final ModuleManager moduleManager;
    private final ResourceMinimizer resourceMinimizer;
    private final boolean minificationEnabled;
    private final Map<String, StreamableResource> cache = Collections.synchronizedMap(CollectionFactory.newCaseInsensitiveMap());
    final StreamableReader libraryReader = new StreamableReader(){

        @Override
        public String read(StreamableResource resource) throws IOException {
            return JavaScriptStackAssemblerImpl.getContent(resource);
        }
    };
    private static final Pattern DEFINE = Pattern.compile("\\bdefine\\s*\\((?!\\s*['\"])");

    public JavaScriptStackAssemblerImpl(ThreadLocale threadLocale, ResourceChangeTracker resourceChangeTracker, StreamableResourceSource streamableResourceSource, JavaScriptStackSource stackSource, AssetChecksumGenerator checksumGenerator, ModuleManager moduleManager, ResourceMinimizer resourceMinimizer, @Symbol(value="tapestry.enable-minification") boolean minificationEnabled) {
        this.threadLocale = threadLocale;
        this.resourceChangeTracker = resourceChangeTracker;
        this.streamableResourceSource = streamableResourceSource;
        this.stackSource = stackSource;
        this.checksumGenerator = checksumGenerator;
        this.moduleManager = moduleManager;
        this.resourceMinimizer = resourceMinimizer;
        this.minificationEnabled = minificationEnabled;
        resourceChangeTracker.clearOnInvalidation(this.cache);
    }

    @Override
    public StreamableResource assembleJavaScriptResourceForStack(String stackName, boolean compress, JavaScriptAggregationStrategy javascriptAggregationStrategy) throws IOException {
        Locale locale = this.threadLocale.getLocale();
        return this.assembleJavascriptResourceForStack(new Parameters(locale, stackName, compress, javascriptAggregationStrategy));
    }

    private StreamableResource assembleJavascriptResourceForStack(Parameters parameters) throws IOException {
        String key = String.format("%s[%s] %s", parameters.stackName, parameters.compress ? "COMPRESS" : "UNCOMPRESSED", parameters.locale.toString());
        StreamableResource result = this.cache.get(key);
        if (result == null) {
            result = this.assemble(parameters);
            this.cache.put(key, result);
        }
        return result;
    }

    private StreamableResource assemble(Parameters parameters) throws IOException {
        if (parameters.compress) {
            StreamableResource uncompressed = this.assembleJavascriptResourceForStack(parameters.disableCompress());
            return new CompressedStreamableResource(uncompressed, this.checksumGenerator);
        }
        JavaScriptStack stack = this.stackSource.getStack(parameters.stackName);
        return this.assembleStreamableForStack(parameters.locale.toString(), parameters, stack.getJavaScriptLibraries(), stack.getModules());
    }

    static String getContent(StreamableResource resource) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(resource.getSize());
        resource.streamTo(bos);
        return new String(bos.toByteArray(), "UTF-8");
    }

    private StreamableResource assembleStreamableForStack(String localeName, Parameters parameters, List<Asset> libraries, List<String> moduleNames) throws IOException {
        Resource resource;
        Assembly assembly = new Assembly(String.format("'%s' JavaScript stack, for locale %s, resources=", parameters.stackName, localeName));
        for (Asset library : libraries) {
            resource = library.getResource();
            assembly.add(resource, this.libraryReader);
        }
        for (String moduleName : moduleNames) {
            resource = this.moduleManager.findResourceForModule(moduleName);
            if (resource == null) {
                throw new IllegalArgumentException(String.format("Could not identify a resource for module name '%s'.", moduleName));
            }
            assembly.add(resource, new ModuleReader(moduleName));
        }
        StreamableResource streamable = assembly.finish();
        if (this.minificationEnabled && parameters.javascriptAggregationStrategy.enablesMinimize()) {
            return this.resourceMinimizer.minimize(streamable);
        }
        return streamable;
    }

    private class Assembly {
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2000);
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, "UTF-8"));
        long lastModified = 0L;
        final StringBuilder description;
        private String sep = "";

        private Assembly(String description) throws UnsupportedEncodingException {
            this.description = new StringBuilder(description);
        }

        void add(Resource resource, StreamableReader reader) throws IOException {
            this.writer.format("\n/* %s */;\n", resource.toString());
            this.description.append(this.sep).append(resource.toString());
            this.sep = ", ";
            StreamableResource streamable = JavaScriptStackAssemblerImpl.this.streamableResourceSource.getStreamableResource(resource, StreamableResourceProcessing.FOR_AGGREGATION, JavaScriptStackAssemblerImpl.this.resourceChangeTracker);
            this.writer.print(reader.read(streamable));
            this.lastModified = Math.max(this.lastModified, streamable.getLastModified());
        }

        StreamableResource finish() {
            this.writer.close();
            return new StreamableResourceImpl(this.description.toString(), JAVASCRIPT_CONTENT_TYPE, CompressionStatus.COMPRESSABLE, this.lastModified, new BytestreamCache(this.outputStream), JavaScriptStackAssemblerImpl.this.checksumGenerator, null);
        }
    }

    private static class ModuleReader
    implements StreamableReader {
        final String moduleName;

        private ModuleReader(String moduleName) {
            this.moduleName = moduleName;
        }

        @Override
        public String read(StreamableResource resource) throws IOException {
            String content = JavaScriptStackAssemblerImpl.getContent(resource);
            return this.transform(content);
        }

        public String transform(String moduleContent) {
            return DEFINE.matcher(moduleContent).replaceFirst("define(\"" + this.moduleName + "\",");
        }
    }

    static interface StreamableReader {
        public String read(StreamableResource var1) throws IOException;
    }

    private class Parameters {
        final Locale locale;
        final String stackName;
        final boolean compress;
        final JavaScriptAggregationStrategy javascriptAggregationStrategy;

        private Parameters(Locale locale, String stackName, boolean compress, JavaScriptAggregationStrategy javascriptAggregationStrategy) {
            this.locale = locale;
            this.stackName = stackName;
            this.compress = compress;
            this.javascriptAggregationStrategy = javascriptAggregationStrategy;
        }

        Parameters disableCompress() {
            return new Parameters(this.locale, this.stackName, false, this.javascriptAggregationStrategy);
        }
    }
}

