/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.internal.plastic.asm.ClassReader;
import org.apache.tapestry5.internal.plastic.asm.ClassVisitor;
import org.apache.tapestry5.internal.plastic.asm.MethodVisitor;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.commons.JSRInlinerAdapter;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.internal.plastic.asm.util.TraceClassVisitor;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodDescription;

public class PlasticInternalUtils {
    public static final String[] EMPTY = new String[0];
    private static final Pattern DESC = Pattern.compile("^L(.*);$");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^(m?_+)?(.+?)_*$", 2);
    private static final Map<String, Class> PRIMITIVES = new HashMap<String, Class>();

    public static boolean isEmpty(Object[] input) {
        return input == null || input.length == 0;
    }

    public static String[] orEmpty(String[] input) {
        return input == null ? EMPTY : input;
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static boolean isNonBlank(String input) {
        return !PlasticInternalUtils.isBlank(input);
    }

    public static String toInternalName(String className) {
        assert (PlasticInternalUtils.isNonBlank(className));
        return className.replace('.', '/');
    }

    public static String toClassPath(String className) {
        return PlasticInternalUtils.toInternalName(className) + ".class";
    }

    public static String toMessage(Throwable t) {
        String message = t.getMessage();
        return PlasticInternalUtils.isBlank(message) ? t.getClass().getName() : message;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static MethodDescription toMethodDescription(MethodNode node) {
        String returnType = Type.getReturnType(node.desc).getClassName();
        String[] arguments = PlasticInternalUtils.toClassNames(Type.getArgumentTypes(node.desc));
        List<String> exceptions = node.exceptions;
        String[] exceptionClassNames = new String[exceptions.size()];
        for (int i = 0; i < exceptionClassNames.length; ++i) {
            exceptionClassNames[i] = exceptions.get(i).replace('/', '.');
        }
        return new MethodDescription(node.access, returnType, node.name, arguments, node.signature, exceptionClassNames);
    }

    private static String[] toClassNames(Type[] types) {
        if (PlasticInternalUtils.isEmpty(types)) {
            return EMPTY;
        }
        String[] result = new String[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = types[i].getClassName();
        }
        return result;
    }

    public static String toClassName(String internalName) {
        assert (PlasticInternalUtils.isNonBlank(internalName));
        return internalName.replace('/', '.');
    }

    public static String toDescriptor(String className) {
        String baseDesc;
        String buffer = className;
        int arrayDepth = 0;
        while (buffer.endsWith("[]")) {
            ++arrayDepth;
            buffer = buffer.substring(0, buffer.length() - 2);
        }
        PrimitiveType type = PrimitiveType.getByName(buffer);
        String string = baseDesc = type == null ? "L" + buffer.replace('.', '/') + ";" : type.descriptor;
        if (arrayDepth == 0) {
            return baseDesc;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < arrayDepth; ++i) {
            b.append('[');
        }
        b.append(baseDesc);
        return b.toString();
    }

    public static String objectDescriptorToClassName(String descriptor) {
        assert (descriptor != null);
        Matcher matcher = DESC.matcher(descriptor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input '%s' is not an object descriptor.", descriptor));
        }
        return PlasticInternalUtils.toClassName(matcher.group(1));
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <T> Set<T> newSet() {
        return new HashSet();
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static String dissasembleBytecode(ClassNode classNode) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        TraceClassVisitor visitor = new TraceClassVisitor(writer);
        classNode.accept(visitor);
        writer.close();
        return stringWriter.toString();
    }

    public static String toPropertyName(String fieldName) {
        Matcher matcher = PROPERTY_PATTERN.matcher(fieldName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Field name '%s' can not be converted to a property name.", fieldName));
        }
        return matcher.group(2);
    }

    public static String capitalize(String input) {
        char first = input.charAt(0);
        if (Character.isUpperCase(first)) {
            return input;
        }
        return String.valueOf(Character.toUpperCase(first)) + input.substring(1);
    }

    public static Class toClass(ClassLoader loader, String javaName) throws ClassNotFoundException {
        int depth = 0;
        while (javaName.endsWith("[]")) {
            ++depth;
            javaName = javaName.substring(0, javaName.length() - 2);
        }
        Class<?> primitive = PRIMITIVES.get(javaName);
        if (primitive != null) {
            Class<?> result = primitive;
            for (int i = 0; i < depth; ++i) {
                result = Array.newInstance(result, 0).getClass();
            }
            return result;
        }
        if (depth == 0) {
            return Class.forName(javaName, true, loader);
        }
        StringBuilder builder = new StringBuilder(20);
        for (int i = 0; i < depth; ++i) {
            builder.append('[');
        }
        builder.append('L').append(javaName).append(';');
        return Class.forName(builder.toString(), true, loader);
    }

    public static Object getFromInstanceContext(InstanceContext context, String javaName) {
        ClassLoader loader = context.getInstanceType().getClassLoader();
        try {
            Class valueType = PlasticInternalUtils.toClass(loader, javaName);
            return context.get(valueType);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isEqual(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    static byte[] readBytestream(InputStream stream) throws IOException {
        int length;
        byte[] buffer = new byte[5000];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((length = stream.read(buffer)) >= 0) {
            bos.write(buffer, 0, length);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] readBytecodeForClass(ClassLoader loader, String className, boolean mustExist) {
        String path = PlasticInternalUtils.toClassPath(className);
        InputStream stream = null;
        try {
            stream = PlasticInternalUtils.getStreamForPath(loader, path);
            if (stream == null) {
                if (mustExist) {
                    throw new RuntimeException(String.format("Unable to locate class file for '%s' in class loader %s.", className, loader));
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = PlasticInternalUtils.readBytestream(stream);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Failure reading bytecode for class %s: %s", className, PlasticInternalUtils.toMessage(ex)), ex);
        }
        finally {
            PlasticInternalUtils.close(stream);
        }
    }

    static InputStream getStreamForPath(ClassLoader loader, String path) throws IOException {
        URL url = loader.getResource(path);
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            try {
                return new FileInputStream(new File(url.toURI()));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return url.openStream();
    }

    public static ClassNode convertBytecodeToClassNode(byte[] bytecode) {
        ClassReader cr = new ClassReader(bytecode);
        ClassNode result = new ClassNode();
        ClassVisitor adapter = new ClassVisitor(458752, result){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor delegate = super.visitMethod(access, name, desc, signature, exceptions);
                return new JSRInlinerAdapter(delegate, access, name, desc, signature, exceptions);
            }
        };
        cr.accept(adapter, 0);
        return result;
    }

    static {
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("char", Character.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVES.put("void", Void.TYPE);
    }
}

