/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.jpa.EntityTransactionManager;
import org.slf4j.Logger;

public class PersistenceContextSpecificEntityTransactionManager {
    private final Logger logger;
    private final EntityManager entityManager;
    private boolean transactionBeingCommitted;
    private Deque<Invokable<?>> invokableUnitsForSequentialTransactions = new ArrayDeque();
    private Deque<Invokable<?>> invokableUnits = new ArrayDeque();
    private List<Invokable<Boolean>> beforeCommitInvokables = new ArrayList<Invokable<Boolean>>();
    private List<Invokable<Boolean>> afterCommitInvokables = new ArrayList<Invokable<Boolean>>();

    public PersistenceContextSpecificEntityTransactionManager(Logger logger, EntityManager entityManager) {
        this.logger = logger;
        this.entityManager = entityManager;
    }

    private EntityTransaction getTransaction() {
        EntityTransaction transaction = this.entityManager.getTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
        return transaction;
    }

    public void addBeforeCommitInvokable(Invokable<Boolean> invokable) {
        this.beforeCommitInvokables.add(invokable);
    }

    public void addAfterCommitInvokable(Invokable<Boolean> invokable) {
        this.afterCommitInvokables.add(invokable);
    }

    public <T> T invokeInTransaction(Invokable<T> invokable) {
        if (this.transactionBeingCommitted) {
            if (invokable instanceof EntityTransactionManager.VoidInvokable) {
                this.invokableUnitsForSequentialTransactions.push(invokable);
                return null;
            }
            PersistenceContextSpecificEntityTransactionManager.rollbackTransaction(this.getTransaction());
            throw new RuntimeException("Current transaction is already being committed. Transactions started @PostCommit are not allowed to return a value");
        }
        boolean topLevel = this.invokableUnits.isEmpty();
        this.invokableUnits.push(invokable);
        if (!topLevel && this.logger.isWarnEnabled()) {
            this.logger.warn("Nested transaction detected, current depth = " + this.invokableUnits.size());
        }
        EntityTransaction transaction = this.getTransaction();
        try {
            Object result = invokable.invoke();
            if (topLevel && this.invokableUnits.peek().equals(invokable)) {
                if (transaction.isActive()) {
                    this.invokeBeforeCommit(transaction);
                }
                if (transaction.isActive()) {
                    this.transactionBeingCommitted = true;
                    transaction.commit();
                    this.transactionBeingCommitted = false;
                    this.invokableUnits.clear();
                    this.invokeAfterCommit();
                    if (this.invokableUnitsForSequentialTransactions.size() > 0) {
                        this.invokeInTransaction(this.invokableUnitsForSequentialTransactions.pop());
                    }
                }
            }
            Object object = result;
            return (T)object;
        }
        catch (RuntimeException e) {
            if (transaction != null && transaction.isActive()) {
                PersistenceContextSpecificEntityTransactionManager.rollbackTransaction(transaction);
            }
            throw e;
        }
        finally {
            this.invokableUnits.remove(invokable);
        }
    }

    private void invokeBeforeCommit(EntityTransaction transaction) {
        Iterator<Invokable<Boolean>> i = this.beforeCommitInvokables.iterator();
        while (i.hasNext()) {
            Invokable<Boolean> invokable = i.next();
            i.remove();
            Boolean beforeCommitSucceeded = PersistenceContextSpecificEntityTransactionManager.tryInvoke(transaction, invokable);
            if (beforeCommitSucceeded == null || beforeCommitSucceeded.booleanValue()) continue;
            PersistenceContextSpecificEntityTransactionManager.rollbackTransaction(transaction);
            break;
        }
    }

    private void invokeAfterCommit() {
        Iterator<Invokable<Boolean>> i = this.afterCommitInvokables.iterator();
        while (i.hasNext()) {
            Invokable<Boolean> invokable = i.next();
            i.remove();
            Boolean afterCommitSucceeded = (Boolean)invokable.invoke();
            if (afterCommitSucceeded == null || afterCommitSucceeded.booleanValue()) continue;
            if (this.invokableUnitsForSequentialTransactions.size() > 0) {
                throw new RuntimeException("After commit hook returned false but there are still uncommitted Invokables scheduled for the next transaction");
            }
            return;
        }
    }

    private static <T> T tryInvoke(EntityTransaction transaction, Invokable<T> invokable) throws RuntimeException {
        Object result;
        try {
            result = invokable.invoke();
        }
        catch (RuntimeException e) {
            if (transaction != null && transaction.isActive()) {
                PersistenceContextSpecificEntityTransactionManager.rollbackTransaction(transaction);
            }
            throw e;
        }
        return (T)result;
    }

    private static void rollbackTransaction(EntityTransaction transaction) {
        try {
            transaction.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

