/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.lang.BooleanUtils;

public abstract class AbstractConfiguration
implements Configuration {
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";
    private static char DELIMITER = (char)44;
    private static final int INITIAL_LIST_SIZE = 2;
    private boolean throwExceptionOnMissing = false;

    public static void setDelimiter(char delimiter) {
        DELIMITER = delimiter;
    }

    public static char getDelimiter() {
        return DELIMITER;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void addProperty(String key, Object token) {
        if (token instanceof String) {
            Iterator it = this.split((String)token).iterator();
            while (it.hasNext()) {
                this.addPropertyDirect(key, it.next());
            }
        } else if (token instanceof Collection) {
            Iterator it = ((Collection)token).iterator();
            while (it.hasNext()) {
                this.addProperty(key, it.next());
            }
        } else {
            this.addPropertyDirect(key, token);
        }
    }

    protected abstract Object getPropertyDirect(String var1);

    protected abstract void addPropertyDirect(String var1, Object var2);

    protected String interpolate(String base) {
        return this.interpolateHelper(base, null);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String variable = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            variable = base.substring(begin + START_TOKEN.length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuffer priorVariableSb = new StringBuffer();
                Iterator it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append(it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = this.getProperty(variable);
            if (value != null) {
                result.append(this.interpolateHelper(value.toString(), priorVariables));
                priorVariables.remove(priorVariables.size() - 1);
            } else {
                result.append(START_TOKEN).append(variable).append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    protected List split(String token) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (token.indexOf(DELIMITER) > 0) {
            PropertiesTokenizer tokenizer = new PropertiesTokenizer(token);
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        } else {
            list.add(token);
        }
        return list;
    }

    public Configuration subset(String prefix) {
        return new SubsetConfiguration(this, prefix, ".");
    }

    public abstract boolean isEmpty();

    public abstract boolean containsKey(String var1);

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public abstract void clearProperty(String var1);

    public abstract Iterator getKeys();

    public Iterator getKeys(final String prefix) {
        return new FilterIterator(this.getKeys(), new Predicate(){

            public boolean evaluate(Object obj) {
                String key = (String)obj;
                return key.startsWith(prefix + ".") || key.equals(prefix);
            }
        });
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = defaults == null ? new Properties() : new Properties(defaults);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                if (tokens.length == 1 && "".equals(token)) break;
                throw new IllegalArgumentException('\'' + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            ((Hashtable)props).put(pkey, pvalue);
        }
        return props;
    }

    public Object getProperty(String key) {
        return this.getPropertyDirect(key);
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, BooleanUtils.toBooleanObject((boolean)defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)((String)value));
            if (b == null) {
                throw new ConversionException('\'' + key + "' doesn't map to a Boolean object");
            }
            return b;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Boolean object");
    }

    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            try {
                Byte b = new Byte((String)value);
                return b;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Byte object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Byte object");
    }

    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                Double d = new Double((String)value);
                return d;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Double object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Double object");
    }

    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            try {
                Float f = new Float((String)value);
                return f;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Float object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Float object");
    }

    public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                Integer i = new Integer((String)value);
                return i;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Integer object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Integer object");
    }

    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                Long l = new Long((String)value);
                return l;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Long object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Long object");
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                Short s = new Short((String)value);
                return s;
            }
            catch (NumberFormatException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a Short object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a Short object");
    }

    public BigDecimal getBigDecimal(String key) {
        BigDecimal number = this.getBigDecimal(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof String) {
            try {
                BigDecimal number = new BigDecimal((String)value);
                return number;
            }
            catch (Exception e) {
                throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object");
    }

    public BigInteger getBigInteger(String key) {
        BigInteger number = this.getBigInteger(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof String) {
            try {
                BigInteger number = new BigInteger((String)value);
                return number;
            }
            catch (Exception e) {
                throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
            }
        }
        if (value == null) {
            return defaultValue;
        }
        throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object");
    }

    public String getString(String key) {
        String s = this.getString(key, null);
        if (s != null) {
            return s;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            return this.interpolate(defaultValue);
        }
        throw new ConversionException('\'' + key + "' doesn't map to a String object");
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(String key) {
        void var3_3;
        String[] tokens;
        Object value = this.getPropertyDirect(key);
        if (value instanceof String) {
            tokens = new String[]{this.interpolate((String)value)};
        } else if (value instanceof List) {
            List list = (List)value;
            tokens = new String[list.size()];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = this.interpolate((String)list.get(i));
            }
        } else if (value == null) {
            tokens = new String[]{};
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a String/List object");
        }
        return var3_3;
    }

    public List getList(String key) {
        return this.getList(key, new ArrayList());
    }

    public List getList(String key, List defaultValue) {
        Object value = this.getPropertyDirect(key);
        List<Object> list = null;
        if (value instanceof String) {
            list = new ArrayList<Object>(1);
            list.add(value);
        } else if (value instanceof List) {
            list = (List)value;
        } else if (value == null) {
            list = defaultValue;
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a List object: " + value + ", a " + value.getClass().getName());
        }
        return list;
    }

    public Vector getVector(String key) {
        return this.getVector(key, new Vector());
    }

    public Vector getVector(String key, Vector defaultValue) {
        Object value = this.getPropertyDirect(key);
        Vector<Object> vector = null;
        if (value instanceof String) {
            vector = new Vector<Object>(1);
            vector.add(value);
        } else if (value instanceof List) {
            vector = new Vector<Object>(((List)value).size());
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                vector.add(obj);
            }
        } else if (value == null) {
            vector = defaultValue;
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a Vector object: " + value + ", a " + value.getClass().getName());
        }
        return vector;
    }

    private Object resolveContainerStore(String key) {
        Object value = this.getPropertyDirect(key);
        if (value != null && value instanceof List) {
            List list = (List)value;
            value = list.isEmpty() ? null : list.get(0);
        }
        return value;
    }

    static class PropertiesTokenizer
    extends StringTokenizer {
        public PropertiesTokenizer(String string) {
            super(string, String.valueOf(DELIMITER));
        }

        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (token.endsWith("\\")) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(DELIMITER);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }
}

