/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.util.security.SecuritySet;

public class PermissionSet
extends SecuritySet {
    private static final long serialVersionUID = 8276935936763076884L;

    public PermissionSet() {
    }

    public PermissionSet(Collection permissions) {
        this.add(permissions);
    }

    public boolean add(Permission permission) {
        boolean res = this.contains(permission);
        this.nameMap.put(permission.getName(), permission);
        this.idMap.put(permission.getIdAsObj(), permission);
        return res;
    }

    public boolean add(Collection permissions) {
        boolean res = false;
        Iterator it = permissions.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            res |= this.add(p);
        }
        return res;
    }

    public boolean add(PermissionSet permissionSet) {
        boolean res = false;
        Iterator it = permissionSet.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            res |= this.add(p);
        }
        return res;
    }

    public boolean remove(Permission permission) {
        boolean res = this.contains(permission);
        this.nameMap.remove(permission.getName());
        this.idMap.remove(permission.getIdAsObj());
        return res;
    }

    public boolean contains(Permission permission) {
        return this.nameMap.containsValue(permission);
    }

    public Permission getPermission(String permissionName) {
        return this.getPermissionByName(permissionName);
    }

    public Permission getPermissionByName(String permissionName) {
        return StringUtils.isNotEmpty((String)permissionName) ? (Permission)this.nameMap.get(permissionName) : null;
    }

    public Permission getPermissionById(int permissionId) {
        return permissionId != 0 ? (Permission)this.idMap.get(new Integer(permissionId)) : null;
    }

    public Permission[] getPermissionsArray() {
        return this.getSet().toArray(new Permission[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PermissionSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            sb.append('[');
            sb.append(p.getName());
            sb.append(" -> ");
            sb.append(p.getIdAsObj());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

