/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class DerbyAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 6265962681516206415L;
    private static Log log = LogFactory.getLog(DerbyAdapter.class);

    protected DerbyAdapter() {
    }

    public String toUpperCase(String str) {
        return new StringBuffer("UPPER(").append(str).append(")").toString();
    }

    public String ignoreCase(String str) {
        return this.toUpperCase(str);
    }

    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    public String getIDMethodSQL(Object obj) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            StringBuffer stmt = new StringBuffer();
            stmt.append("LOCK TABLE ").append(table).append(" IN EXCLUSIVE MODE");
            statement.executeUpdate(stmt.toString());
            statement.close();
            statement = null;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Could not close statement", (Throwable)e);
                }
            }
        }
    }

    public void unlockTable(Connection con, String table) throws SQLException {
    }

    public boolean escapeText() {
        return false;
    }

    public boolean useEscapeClauseForLike() {
        return true;
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public boolean supportsNativeOffset() {
        return true;
    }

    public void generateLimits(Query query, long offset, int limit) {
        StringBuilder postLimit = new StringBuilder();
        if (offset > 0L) {
            postLimit.append(" OFFSET ").append(offset).append(" ROWS");
        }
        if (limit >= 0) {
            postLimit.append(" FETCH NEXT ").append(limit).append(" ROWS ONLY");
        }
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
        query.setOffset(null);
    }
}

