/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.pipeline.Pipeline;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.TurbinePipeline;
import org.apache.turbine.services.Initable;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;

public class Turbine
extends HttpServlet {
    private static final long serialVersionUID = -6317118078613623990L;
    public static final String REDIRECTED_PATHINFO_NAME = "redirected";
    public static final String BASEDIR_KEY = "basedir";
    private static boolean firstInit = true;
    private static Pipeline pipeline = null;
    private static Throwable initFailure = null;
    private static boolean firstDoGet = true;
    private static volatile ServerData serverData = null;
    private static String applicationRoot;
    private static ServletConfig servletConfig;
    private static ServletContext servletContext;
    private static String webappRoot;
    private static Configuration configuration;
    private String inputEncoding = null;
    private static Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Class<Turbine> clazz = Turbine.class;
        synchronized (Turbine.class) {
            super.init();
            if (!firstInit) {
                log.info((Object)"Double initialization of Turbine was attempted!");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            firstInit = false;
            ServletConfig config = this.getServletConfig();
            try {
                ServletContext context = config.getServletContext();
                this.configure(config, context);
                TemplateService templateService = (TemplateService)this.getServiceManager().getService("TemplateService");
                if (templateService == null) {
                    throw new TurbineException("No Template Service configured!");
                }
                if (this.getRunDataService() == null) {
                    throw new TurbineException("No RunData Service configured!");
                }
            }
            catch (Throwable e) {
                initFailure = e;
                log.fatal((Object)"Turbine: init() failed: ", e);
                throw new ServletException("Turbine: init() failed", e);
            }
            log.info((Object)"Turbine: init() Ready to Rumble!");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void configure(ServletConfig config, ServletContext context) throws Exception {
        applicationRoot = this.findInitParameter(context, config, "applicationRoot", "webContext");
        webappRoot = context.getRealPath("/");
        if (applicationRoot == null || applicationRoot.equals("webContext")) {
            applicationRoot = webappRoot;
        }
        Turbine.setApplicationRoot(applicationRoot);
        this.createRuntimeDirectories(context, config);
        ConfigurationStyle confStyle = ConfigurationStyle.UNSET;
        String confFile = this.findInitParameter(context, config, "configuration", null);
        if (StringUtils.isNotEmpty((String)confFile)) {
            confStyle = ConfigurationStyle.XML;
        } else {
            confFile = this.findInitParameter(context, config, "properties", null);
            if (StringUtils.isNotEmpty((String)confFile)) {
                confStyle = ConfigurationStyle.PROPERTIES;
            }
        }
        if (confStyle == ConfigurationStyle.UNSET) {
            confFile = this.findInitParameter(context, config, "properties", "/WEB-INF/conf/TurbineResources.properties");
            confStyle = ConfigurationStyle.PROPERTIES;
        }
        switch (confStyle) {
            case XML: {
                if (confFile.startsWith("/")) {
                    confFile = confFile.substring(1);
                }
                DefaultConfigurationBuilder configurationBuilder = new DefaultConfigurationBuilder(confFile);
                String confPath = new File(Turbine.getApplicationRoot()).toURI().toString();
                configurationBuilder.setBasePath(confPath);
                configuration = configurationBuilder.getConfiguration();
                break;
            }
            case PROPERTIES: {
                configuration = new PropertiesConfiguration(Turbine.getRealPath(confFile));
                break;
            }
        }
        this.configureLogging();
        log.info((Object)("Loaded configuration (" + (Object)((Object)confStyle) + ") from " + confFile + " style: " + configuration.toString()));
        Turbine.setTurbineServletConfig(config);
        Turbine.setTurbineServletContext(context);
        this.getServiceManager().setApplicationRoot(applicationRoot);
        configuration.setProperty("applicationRoot", (Object)applicationRoot);
        configuration.setProperty("webappRoot", (Object)webappRoot);
        this.inputEncoding = configuration.getString("input.encoding", "ISO-8859-1");
        configuration.setProperty("locale.default.charset", (Object)this.inputEncoding);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input Encoding has been set to " + this.inputEncoding));
        }
        this.getServiceManager().setConfiguration(configuration);
        this.getServiceManager().init();
        String descriptorPath = configuration.getString("pipeline.default.descriptor", "/WEB-INF/conf/turbine-classic-pipeline.xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using descriptor path: " + descriptorPath));
        }
        if (!descriptorPath.startsWith("/")) {
            descriptorPath = "/" + descriptorPath;
        }
        InputStream reader = context.getResourceAsStream(descriptorPath);
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{TurbinePipeline.class});
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        pipeline = (Pipeline)unmarshaller.unmarshal(reader);
        IOUtils.closeQuietly((InputStream)reader);
        log.debug((Object)"Initializing pipeline");
        pipeline.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureLogging() throws IOException {
        String log4jFile = configuration.getString("log4j.file", "/WEB-INF/conf/Log4j.properties");
        if (StringUtils.isNotEmpty((String)log4jFile) && !log4jFile.equalsIgnoreCase("none")) {
            log4jFile = Turbine.getRealPath(log4jFile);
            boolean success = false;
            if (log4jFile.endsWith(".xml")) {
                try {
                    DOMConfigurator.configure((String)log4jFile);
                    success = true;
                }
                catch (FactoryConfigurationError e) {
                    System.err.println("Could not configure Log4J from configuration file " + log4jFile + ": ");
                    e.printStackTrace();
                }
            } else {
                Properties p = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(log4jFile);
                    p.load(fis);
                    p.setProperty("applicationRoot", Turbine.getApplicationRoot());
                    PropertyConfigurator.configure((Properties)p);
                    success = true;
                }
                catch (FileNotFoundException fnf) {
                    System.err.println("Could not open Log4J configuration file " + log4jFile + ": ");
                    fnf.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            if (success) {
                log = LogFactory.getLog(((Object)((Object)this)).getClass());
                log.info((Object)("Configured log4j from " + log4jFile));
            }
        }
    }

    protected void createRuntimeDirectories(ServletContext context, ServletConfig config) {
        String path = this.findInitParameter(context, config, "loggingRoot", "/logs");
        File logDir = new File(Turbine.getRealPath(path));
        if (!logDir.exists() && !logDir.mkdirs()) {
            System.err.println("Cannot create directory for logs!");
        }
    }

    protected String findInitParameter(ServletContext context, ServletConfig config, String name, String defaultValue) {
        String path = null;
        boolean usingNamespace = name.startsWith("org.apache.turbine");
        while (StringUtils.isEmpty((String)(path = config.getInitParameter(name))) && StringUtils.isEmpty((String)(path = context.getInitParameter(name)))) {
            if (usingNamespace) {
                path = defaultValue;
                break;
            }
            name = "org.apache.turbine." + name;
            usingNamespace = true;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PipelineData data) {
        Class<Turbine> clazz = Turbine.class;
        synchronized (Turbine.class) {
            if (firstDoGet) {
                Turbine.saveServletInfo(data);
                TurbineServices services = (TurbineServices)this.getServiceManager();
                Iterator<String> i = services.getServiceNames();
                while (i.hasNext()) {
                    String serviceName = i.next();
                    Object service = services.getService(serviceName);
                    if (!(service instanceof Initable)) continue;
                    try {
                        ((Initable)service).init(data);
                    }
                    catch (InitializationException e) {
                        log.warn((Object)("Could not initialize Initable " + serviceName + " with PipelineData"), (Throwable)e);
                    }
                }
                firstDoGet = false;
                log.info((Object)"Turbine: first Request successful");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static String getServerName() {
        return Turbine.getDefaultServerData().getServerName();
    }

    public static String getServerScheme() {
        return Turbine.getDefaultServerData().getServerScheme();
    }

    public static String getServerPort() {
        return Integer.toString(Turbine.getDefaultServerData().getServerPort());
    }

    public static String getScriptName() {
        return Turbine.getDefaultServerData().getScriptName();
    }

    public static String getContextPath() {
        return Turbine.getDefaultServerData().getContextPath();
    }

    public static ServerData getDefaultServerData() {
        if (serverData == null) {
            String serverName = configuration.getString("serverdata.default.serverName");
            if (serverName == null) {
                log.error((Object)"ServerData Information requested from Turbine before first request!");
            } else {
                log.info((Object)"ServerData Information retrieved from configuration.");
            }
            serverData = new ServerData(serverName, configuration.getInt("serverdata.default.serverPort", 80), configuration.getString("serverdata.default.serverScheme", "http"), configuration.getString("serverdata.default.scriptName"), configuration.getString("serverdata.default.contextPath"));
        }
        return serverData;
    }

    public static void setTurbineServletConfig(ServletConfig config) {
        servletConfig = config;
    }

    public static ServletConfig getTurbineServletConfig() {
        return servletConfig;
    }

    public static void setTurbineServletContext(ServletContext context) {
        servletContext = context;
    }

    public static ServletContext getTurbineServletContext() {
        return servletContext;
    }

    public void destroy() {
        this.getServiceManager().shutdownServices();
        firstInit = true;
        firstDoGet = true;
        log.info((Object)"Turbine: Done shutting down!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        RunData pipelineData = null;
        try {
            if (initFailure != null) {
                throw initFailure;
            }
            if (req.getCharacterEncoding() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Changing Input Encoding to " + this.inputEncoding));
                }
                try {
                    req.setCharacterEncoding(this.inputEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    log.warn((Object)("Could not change request encoding to " + this.inputEncoding), (Throwable)uee);
                }
            }
            pipelineData = this.getRunDataService().getRunData(req, res, this.getServletConfig());
            HashMap<Class<RunData>, RunData> runDataMap = new HashMap<Class<RunData>, RunData>();
            runDataMap.put(RunData.class, pipelineData);
            pipelineData.put(RunData.class, runDataMap);
            if (firstDoGet) {
                this.init(pipelineData);
            }
            pipeline.invoke(pipelineData);
            this.getRunDataService().putRunData(pipelineData);
        }
        catch (Exception e) {
            this.handleException(pipelineData, res, e);
        }
        catch (Throwable t) {
            this.handleException(pipelineData, res, t);
            this.getRunDataService().putRunData(pipelineData);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getRunDataService().putRunData(pipelineData);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public String getServletInfo() {
        return "Turbine Servlet";
    }

    protected void handleException(PipelineData pipelineData, HttpServletResponse res, Throwable t) {
        RunData data = (RunData)pipelineData;
        log.error((Object)"Turbine.handleException: ", t);
        String mimeType = "text/plain";
        try {
            data.setStackTrace(ExceptionUtils.getStackTrace((Throwable)t), t);
            data.setScreen(configuration.getString("screen.error", "VelocityErrorScreen"));
            if (data.getTemplateInfo() != null) {
                data.getTemplateInfo().setScreenTemplate(configuration.getString("template.error", "error.vm"));
            }
            data.setAction("");
            PageLoader.getInstance().exec(pipelineData, configuration.getString("page.default", "DefaultPage"));
            data.getResponse().setContentType(data.getContentType());
            data.getResponse().setStatus(data.getStatusCode());
        }
        catch (NoSuchFieldError e) {
            try {
                data.getResponse().setContentType(mimeType);
                data.getResponse().setStatus(200);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                data.getResponse().getWriter().print("java.lang.NoSuchFieldError: Please recompile all of your source code.");
            }
            catch (IOException ignored) {
                // empty catch block
            }
            log.error((Object)data.getStackTrace(), (Throwable)e);
        }
        catch (Throwable reallyScrewedNow) {
            StringBuilder msg = new StringBuilder();
            msg.append("Horrible Exception: ");
            if (data != null) {
                msg.append(data.getStackTrace());
            } else {
                msg.append(t);
            }
            try {
                res.setContentType(mimeType);
                res.setStatus(200);
                res.getWriter().print(msg.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            log.error((Object)reallyScrewedNow.getMessage(), reallyScrewedNow);
        }
    }

    public static synchronized void saveServletInfo(PipelineData data) {
        ServerData requestServerData = data.get(Turbine.class, ServerData.class);
        serverData = (ServerData)requestServerData.clone();
    }

    public static void setApplicationRoot(String val) {
        applicationRoot = val;
    }

    public static String getApplicationRoot() {
        return applicationRoot;
    }

    public static String getRealPath(String path) {
        if (path.startsWith("/")) {
            return new File(Turbine.getApplicationRoot(), path.substring(1)).getAbsolutePath();
        }
        return new File(Turbine.getApplicationRoot(), path).getAbsolutePath();
    }

    private ServiceManager getServiceManager() {
        return TurbineServices.getInstance();
    }

    public String getDefaultInputEncoding() {
        return this.inputEncoding;
    }

    private RunDataService getRunDataService() {
        return (RunDataService)this.getServiceManager().getService("RunDataService");
    }

    static {
        configuration = null;
        log = LogFactory.getLog(Turbine.class);
    }

    private static enum ConfigurationStyle {
        XML,
        PROPERTIES,
        UNSET;

    }
}

