/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AutoLabelResolver;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.ILabelProvider;
import org.apache.wicket.markup.html.internal.ResponseBufferZone;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class AutoLabelTextResolver
implements IComponentResolver {
    public static final String LABEL = "label";

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag && LABEL.equals(tag.getName())) {
            Component related = null;
            String forAttributeValue = tag.getAttribute("for");
            if (forAttributeValue != null) {
                Component component;
                related = component = AutoLabelResolver.findRelatedComponent(container, forAttributeValue);
            }
            if (related == null) {
                AutoLabelResolver.AutoLabel autoLabel;
                if (container instanceof AutoLabelResolver.AutoLabel) {
                    related = ((AutoLabelResolver.AutoLabel)container).getRelatedComponent();
                }
                if (related == null && (autoLabel = container.findParent(AutoLabelResolver.AutoLabel.class)) != null) {
                    related = autoLabel.getRelatedComponent();
                }
            }
            if (related == null) {
                String forAttr = forAttributeValue != null ? " for=\"" + forAttributeValue + "\"" : "";
                throw new ComponentNotFoundException("no related component found for <wicket:label" + forAttr + ">");
            }
            return new TextLabel(tag.getId(), related);
        }
        return null;
    }

    private static class TextLabel
    extends WebMarkupContainer {
        private final Component labeled;

        public TextLabel(String id, Component labeled) {
            super(id);
            this.labeled = labeled;
            this.setRenderBodyOnly(true);
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            if (tag.isOpenClose()) {
                tag.setType(XmlTag.TagType.OPEN);
            }
            super.onComponentTag(tag);
        }

        @Override
        public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            IModel<String> labelModel = this.findLabelContent(markupStream, openTag);
            this.replaceComponentTagBody(markupStream, openTag, labelModel != null ? labelModel.getObject() : "");
            if (labelModel != null) {
                if (this.labeled instanceof FormComponent) {
                    FormComponent fc = (FormComponent)this.labeled;
                    fc.setLabel((IModel)labelModel);
                } else {
                    labelModel.detach();
                }
            }
        }

        private IModel<String> findLabelContent(final MarkupStream markupStream, final ComponentTag tag) {
            FormComponent formComponent;
            String text;
            ILabelProvider provider;
            if (this.labeled instanceof ILabelProvider && (provider = (ILabelProvider)((Object)this.labeled)).getLabel() != null && !Strings.isEmpty((CharSequence)((CharSequence)provider.getLabel().getObject()))) {
                return provider.getLabel();
            }
            if (this.labeled instanceof FormComponent && !"wicket:unknown".equals(text = (formComponent = (FormComponent)this.labeled).getDefaultLabel("wicket:unknown")) && !Strings.isEmpty((CharSequence)text)) {
                return new LoadableDetachableModel<String>(){

                    @Override
                    protected String load() {
                        return formComponent.getDefaultLabel("wicket:unknown");
                    }
                };
            }
            String resourceKey = tag.getAttribute("key");
            if (resourceKey != null && !Strings.isEmpty((CharSequence)(text = this.labeled.getString(resourceKey)))) {
                return new StringResourceModel(resourceKey, this.labeled);
            }
            String text2 = new ResponseBufferZone(RequestCycle.get(), markupStream){

                @Override
                protected void executeInsideBufferedZone() {
                    TextLabel.super.onComponentTagBody(markupStream, tag);
                }
            }.execute().toString();
            if (!Strings.isEmpty((CharSequence)text2)) {
                return Model.of(text2);
            }
            return null;
        }
    }
}

