/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.debugbar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.DevUtilsPanel;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class DebugBar
extends DevUtilsPanel {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<List<IDebugBarContributor>> CONTRIBS_META_KEY = new MetaDataKey<List<IDebugBarContributor>>(){
        private static final long serialVersionUID = 1L;
    };

    public DebugBar(String id) {
        this(id, true);
    }

    public DebugBar(String id, boolean initiallyExpanded) {
        super(id);
        this.setMarkupId("wicketDebugBar");
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{AttributeModifier.replace((String)"class", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return "wicketDebugBar" + (DebugBar.this.hasErrorMessage() ? "Error" : "");
            }
        })});
        this.add(new Component[]{new Image("logo", (ResourceReference)new PackageResourceReference(DebugBar.class, "wicket.png"), new ResourceReference[0])});
        this.add(new Component[]{this.contentSection("content", initiallyExpanded)});
    }

    public DebugBar positionBottom() {
        this.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"bottom"))});
        return this;
    }

    private Component contentSection(String id, boolean initiallyExpanded) {
        WebMarkupContainer section = new WebMarkupContainer(id);
        if (!initiallyExpanded) {
            section.add(new Behavior[]{AttributeModifier.append((String)"style", (Serializable)((Object)"display:none")).setSeparator(";")});
        }
        List<IDebugBarContributor> contributors = DebugBar.getContributors(this.getApplication());
        section.add(new Component[]{new ListView<IDebugBarContributor>("contributors", contributors){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IDebugBarContributor> item) {
                IDebugBarContributor contrib = (IDebugBarContributor)item.getModelObject();
                Component comp = contrib.createComponent("contrib", DebugBar.this);
                if (comp == null) {
                    item.setVisibilityAllowed(false);
                } else {
                    item.add(new Component[]{comp});
                }
            }
        }});
        section.add(new Component[]{new Image("removeImg", (ResourceReference)new PackageResourceReference(DebugBar.class, "remove.png"), new ResourceReference[0])});
        return section;
    }

    public boolean isVisible() {
        return this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled();
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(DebugBar.class, "wicket-debugbar.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(DebugBar.class, "wicket-debugbar.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"wicketDebugBarCheckState()"));
    }

    public static void registerContributor(IDebugBarContributor contrib) {
        DebugBar.registerContributor(contrib, Application.get());
    }

    public static void registerContributor(IDebugBarContributor contrib, Application application) {
        Args.notNull((Object)contrib, (String)"contrib");
        List<IDebugBarContributor> contributors = DebugBar.getContributors(application);
        contributors.add(contrib);
        DebugBar.setContributors(contributors, application);
    }

    public static List<IDebugBarContributor> getContributors(Application application) {
        List list = (List)application.getMetaData(CONTRIBS_META_KEY);
        return list == null ? new ArrayList() : list;
    }

    public static void setContributors(List<IDebugBarContributor> contributors, Application application) {
        Args.notNull((Object)application, (String)"application");
        application.setMetaData(CONTRIBS_META_KEY, contributors);
    }
}

